rule win_flawedammyy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.flawedammyy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flawedammyy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0022 8a4200 828a4200bb8a42 00ff }
            // n = 4, score = 200
            //   0022                 | add                 byte ptr [edx], ah
            //   8a4200               | mov                 al, byte ptr [edx]
            //   828a4200bb8a42       | or                  byte ptr [edx - 0x7544ffbe], 0x42
            //   00ff                 | add                 bh, bh

        $sequence_1 = { 004bbf 42 0062bf 42 }
            // n = 4, score = 200
            //   004bbf               | add                 byte ptr [ebx - 0x41], cl
            //   42                   | inc                 edx
            //   0062bf               | add                 byte ptr [edx - 0x41], ah
            //   42                   | inc                 edx

        $sequence_2 = { ffd3 f30f7e45ec 8b4df4 83ec10 8b11 }
            // n = 5, score = 200
            //   ffd3                 | call                ebx
            //   f30f7e45ec           | movq                xmm0, qword ptr [ebp - 0x14]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   83ec10               | sub                 esp, 0x10
            //   8b11                 | mov                 edx, dword ptr [ecx]

        $sequence_3 = { 68???????? 8d4df0 e8???????? 8b00 85c0 7404 8b10 }
            // n = 7, score = 200
            //   68????????           |                     
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6
            //   8b10                 | mov                 edx, dword ptr [eax]

        $sequence_4 = { 8d8da0f6ffff 6a00 6a23 51 6a00 ffd0 8b35???????? }
            // n = 7, score = 200
            //   8d8da0f6ffff         | lea                 ecx, [ebp - 0x960]
            //   6a00                 | push                0
            //   6a23                 | push                0x23
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   ffd0                 | call                eax
            //   8b35????????         |                     

        $sequence_5 = { 0062bf 42 0079bf 42 }
            // n = 4, score = 200
            //   0062bf               | add                 byte ptr [edx - 0x41], ah
            //   42                   | inc                 edx
            //   0079bf               | add                 byte ptr [ecx - 0x41], bh
            //   42                   | inc                 edx

        $sequence_6 = { 68f1cbf7ae 6a01 e8???????? 83c408 }
            // n = 4, score = 200
            //   68f1cbf7ae           | push                0xaef7cbf1
            //   6a01                 | push                1
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_7 = { 002a e342 0039 e342 }
            // n = 4, score = 200
            //   002a                 | add                 byte ptr [edx], ch
            //   e342                 | jecxz               0x44
            //   0039                 | add                 byte ptr [ecx], bh
            //   e342                 | jecxz               0x44

        $sequence_8 = { ff5108 8b45fc 50 8b08 ff5108 8b45e4 }
            // n = 6, score = 200
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_9 = { 59 8b7d08 833cfde897410000 755b }
            // n = 4, score = 200
            //   59                   | pop                 ecx
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   833cfde897410000     | cmp                 dword ptr [edi*8 + 0x4197e8], 0
            //   755b                 | jne                 0x5d

        $sequence_10 = { 0039 e342 0048e3 42 }
            // n = 4, score = 200
            //   0039                 | add                 byte ptr [ecx], bh
            //   e342                 | jecxz               0x44
            //   0048e3               | add                 byte ptr [eax - 0x1d], cl
            //   42                   | inc                 edx

        $sequence_11 = { 0000 0404 0404 0404 0401 }
            // n = 5, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   0404                 | add                 al, 4
            //   0404                 | add                 al, 4
            //   0404                 | add                 al, 4
            //   0401                 | add                 al, 1

        $sequence_12 = { 83ec10 660fd600 f30f7e45ac 660fd64008 f30f7e8578ffffff 8bc4 }
            // n = 6, score = 200
            //   83ec10               | sub                 esp, 0x10
            //   660fd600             | movq                qword ptr [eax], xmm0
            //   f30f7e45ac           | movq                xmm0, qword ptr [ebp - 0x54]
            //   660fd64008           | movq                qword ptr [eax + 8], xmm0
            //   f30f7e8578ffffff     | movq                xmm0, qword ptr [ebp - 0x88]
            //   8bc4                 | mov                 eax, esp

        $sequence_13 = { c78508ffffff44000000 66898538ffffff e8???????? 83c404 85c0 7511 68???????? }
            // n = 7, score = 200
            //   c78508ffffff44000000     | mov    dword ptr [ebp - 0xf8], 0x44
            //   66898538ffffff       | mov                 word ptr [ebp - 0xc8], ax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7511                 | jne                 0x13
            //   68????????           |                     

        $sequence_14 = { 00b3854200e5 854200 37 864200 }
            // n = 4, score = 200
            //   00b3854200e5         | add                 byte ptr [ebx - 0x1affbd7b], dh
            //   854200               | test                dword ptr [edx], eax
            //   37                   | aaa                 
            //   864200               | xchg                byte ptr [edx], al

        $sequence_15 = { 0018 874200 58 874200 }
            // n = 4, score = 200
            //   0018                 | add                 byte ptr [eax], bl
            //   874200               | xchg                dword ptr [edx], eax
            //   58                   | pop                 eax
            //   874200               | xchg                dword ptr [edx], eax

        $sequence_16 = { 7e09 8a0e 880a 4a 4e 48 75f7 }
            // n = 7, score = 100
            //   7e09                 | jle                 0xb
            //   8a0e                 | mov                 cl, byte ptr [esi]
            //   880a                 | mov                 byte ptr [edx], cl
            //   4a                   | dec                 edx
            //   4e                   | dec                 esi
            //   48                   | dec                 eax
            //   75f7                 | jne                 0xfffffff9

        $sequence_17 = { ff75ac 8b3d???????? ffd7 ff75a8 }
            // n = 4, score = 100
            //   ff75ac               | push                dword ptr [ebp - 0x54]
            //   8b3d????????         |                     
            //   ffd7                 | call                edi
            //   ff75a8               | push                dword ptr [ebp - 0x58]

        $sequence_18 = { 5e 5b c3 55 8bec 81ec5c040000 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec5c040000         | sub                 esp, 0x45c

        $sequence_19 = { e9???????? 33c0 8b7df4 8b0c855c303400 c1e705 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   8b0c855c303400       | mov                 ecx, dword ptr [eax*4 + 0x34305c]
            //   c1e705               | shl                 edi, 5

        $sequence_20 = { 53 ff75dc 6813100000 ff35???????? ffd6 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   6813100000           | push                0x1013
            //   ff35????????         |                     
            //   ffd6                 | call                esi

        $sequence_21 = { ff15???????? eb08 6a64 ff15???????? 53 ff75a8 ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   eb08                 | jmp                 0xa
            //   6a64                 | push                0x64
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   ff75a8               | push                dword ptr [ebp - 0x58]
            //   ff15????????         |                     

        $sequence_22 = { eb0e 8b14957c303400 49 0fafd1 0155fc }
            // n = 5, score = 100
            //   eb0e                 | jmp                 0x10
            //   8b14957c303400       | mov                 edx, dword ptr [edx*4 + 0x34307c]
            //   49                   | dec                 ecx
            //   0fafd1               | imul                edx, ecx
            //   0155fc               | add                 dword ptr [ebp - 4], edx

        $sequence_23 = { 7426 8b483c ba???????? 03c8 50 66c741160e01 66c7415c0300 }
            // n = 7, score = 100
            //   7426                 | je                  0x28
            //   8b483c               | mov                 ecx, dword ptr [eax + 0x3c]
            //   ba????????           |                     
            //   03c8                 | add                 ecx, eax
            //   50                   | push                eax
            //   66c741160e01         | mov                 word ptr [ecx + 0x16], 0x10e
            //   66c7415c0300         | mov                 word ptr [ecx + 0x5c], 3

        $sequence_24 = { 8b0c855c303400 c1e705 33d2 03fe }
            // n = 4, score = 100
            //   8b0c855c303400       | mov                 ecx, dword ptr [eax*4 + 0x34305c]
            //   c1e705               | shl                 edi, 5
            //   33d2                 | xor                 edx, edx
            //   03fe                 | add                 edi, esi

        $sequence_25 = { 0f872affffff 0fb6805a213400 ff2485f6203400 8b8614080000 3b45f4 7e03 8945f4 }
            // n = 7, score = 100
            //   0f872affffff         | ja                  0xffffff30
            //   0fb6805a213400       | movzx               eax, byte ptr [eax + 0x34215a]
            //   ff2485f6203400       | jmp                 dword ptr [eax*4 + 0x3420f6]
            //   8b8614080000         | mov                 eax, dword ptr [esi + 0x814]
            //   3b45f4               | cmp                 eax, dword ptr [ebp - 0xc]
            //   7e03                 | jle                 5
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_26 = { 7516 68???????? e8???????? 53 ff15???????? e9???????? }
            // n = 6, score = 100
            //   7516                 | jne                 0x18
            //   68????????           |                     
            //   e8????????           |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_27 = { 56 8a0a 80f930 7569 }
            // n = 4, score = 100
            //   56                   | push                esi
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   80f930               | cmp                 cl, 0x30
            //   7569                 | jne                 0x6b

        $sequence_28 = { c745e8ff000000 8b3c857c303400 c745ecffff0000 0faff9 83f801 c745f0ffffff00 741f }
            // n = 7, score = 100
            //   c745e8ff000000       | mov                 dword ptr [ebp - 0x18], 0xff
            //   8b3c857c303400       | mov                 edi, dword ptr [eax*4 + 0x34307c]
            //   c745ecffff0000       | mov                 dword ptr [ebp - 0x14], 0xffff
            //   0faff9               | imul                edi, ecx
            //   83f801               | cmp                 eax, 1
            //   c745f0ffffff00       | mov                 dword ptr [ebp - 0x10], 0xffffff
            //   741f                 | je                  0x21

        $sequence_29 = { 8b4d08 8a0408 a2???????? eb07 c605????????00 c705????????4c403400 ff7508 }
            // n = 7, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8a0408               | mov                 al, byte ptr [eax + ecx]
            //   a2????????           |                     
            //   eb07                 | jmp                 9
            //   c605????????00       |                     
            //   c705????????4c403400     |     
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_30 = { 7518 8b46f8 8b04855c303400 c1e002 50 6a40 }
            // n = 6, score = 100
            //   7518                 | jne                 0x1a
            //   8b46f8               | mov                 eax, dword ptr [esi - 8]
            //   8b04855c303400       | mov                 eax, dword ptr [eax*4 + 0x34305c]
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   6a40                 | push                0x40

        $sequence_31 = { 83f907 0f8781000000 ff248dfd243400 881f eb76 ff30 eb63 }
            // n = 7, score = 100
            //   83f907               | cmp                 ecx, 7
            //   0f8781000000         | ja                  0x87
            //   ff248dfd243400       | jmp                 dword ptr [ecx*4 + 0x3424fd]
            //   881f                 | mov                 byte ptr [edi], bl
            //   eb76                 | jmp                 0x78
            //   ff30                 | push                dword ptr [eax]
            //   eb63                 | jmp                 0x65

    condition:
        7 of them and filesize < 1350656
}