rule win_floxif_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.floxif."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.floxif"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837dfc05 7e02 eb0d 68a00f0000 ff15???????? }
            // n = 5, score = 100
            //   837dfc05             | cmp                 dword ptr [ebp - 4], 5
            //   7e02                 | jle                 4
            //   eb0d                 | jmp                 0xf
            //   68a00f0000           | push                0xfa0
            //   ff15????????         |                     

        $sequence_1 = { eb09 8b45a8 83c001 8945a8 8d4dc0 e8???????? 3945a8 }
            // n = 7, score = 100
            //   eb09                 | jmp                 0xb
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]
            //   83c001               | add                 eax, 1
            //   8945a8               | mov                 dword ptr [ebp - 0x58], eax
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     
            //   3945a8               | cmp                 dword ptr [ebp - 0x58], eax

        $sequence_2 = { 68???????? 8d4de0 e8???????? 68???????? b9???????? e8???????? 6a00 }
            // n = 7, score = 100
            //   68????????           |                     
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e8????????           |                     
            //   68????????           |                     
            //   b9????????           |                     
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_3 = { e8???????? 8d4d08 51 8d4de4 e8???????? c645f400 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   51                   | push                ecx
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   c645f400             | mov                 byte ptr [ebp - 0xc], 0

        $sequence_4 = { 51 8b55f4 52 8b45fc 50 6aff 8b4d08 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   6aff                 | push                -1
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_5 = { 837df800 7e68 8b45f8 83c001 50 6a00 8d8d4cffffff }
            // n = 7, score = 100
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7e68                 | jle                 0x6a
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83c001               | add                 eax, 1
            //   50                   | push                eax
            //   6a00                 | push                0
            //   8d8d4cffffff         | lea                 ecx, [ebp - 0xb4]

        $sequence_6 = { c6855fffffff94 c68560ffffff92 c68561ffffffe1 c6458c00 c6458d00 c6458e72 }
            // n = 6, score = 100
            //   c6855fffffff94       | mov                 byte ptr [ebp - 0xa1], 0x94
            //   c68560ffffff92       | mov                 byte ptr [ebp - 0xa0], 0x92
            //   c68561ffffffe1       | mov                 byte ptr [ebp - 0x9f], 0xe1
            //   c6458c00             | mov                 byte ptr [ebp - 0x74], 0
            //   c6458d00             | mov                 byte ptr [ebp - 0x73], 0
            //   c6458e72             | mov                 byte ptr [ebp - 0x72], 0x72

        $sequence_7 = { e8???????? e8???????? 83c410 682c010000 ff15???????? e8???????? 83ec10 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   682c010000           | push                0x12c
            //   ff15????????         |                     
            //   e8????????           |                     
            //   83ec10               | sub                 esp, 0x10

        $sequence_8 = { 83c40c 8b5510 52 8b450c c1e004 8b4d08 03c8 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   c1e004               | shl                 eax, 4
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   03c8                 | add                 ecx, eax

        $sequence_9 = { 7629 a1???????? 0305???????? 8b4d0c 3981b8000000 7313 }
            // n = 6, score = 100
            //   7629                 | jbe                 0x2b
            //   a1????????           |                     
            //   0305????????         |                     
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   3981b8000000         | cmp                 dword ptr [ecx + 0xb8], eax
            //   7313                 | jae                 0x15

    condition:
        7 of them and filesize < 352256
}