rule win_flusihoc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.flusihoc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flusihoc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740b 40 8816 8a1408 46 }
            // n = 5, score = 400
            //   740b                 | je                  0xd
            //   40                   | inc                 eax
            //   8816                 | mov                 byte ptr [esi], dl
            //   8a1408               | mov                 dl, byte ptr [eax + ecx]
            //   46                   | inc                 esi

        $sequence_1 = { 8b442410 6aff 50 ff15???????? 8b4c2410 }
            // n = 5, score = 400
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   6aff                 | push                -1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_2 = { 57 6a40 8d442428 6a00 50 c744242c44000000 e8???????? }
            // n = 7, score = 400
            //   57                   | push                edi
            //   6a40                 | push                0x40
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c744242c44000000     | mov                 dword ptr [esp + 0x2c], 0x44
            //   e8????????           |                     

        $sequence_3 = { f3a5 c684246402000000 e8???????? 68d6000000 }
            // n = 4, score = 400
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   c684246402000000     | mov                 byte ptr [esp + 0x264], 0
            //   e8????????           |                     
            //   68d6000000           | push                0xd6

        $sequence_4 = { 7507 80864d01000004 83f822 7506 fe8e42010000 }
            // n = 5, score = 400
            //   7507                 | jne                 9
            //   80864d01000004       | add                 byte ptr [esi + 0x14d], 4
            //   83f822               | cmp                 eax, 0x22
            //   7506                 | jne                 8
            //   fe8e42010000         | dec                 byte ptr [esi + 0x142]

        $sequence_5 = { 8bec 83e4f8 81ece40b0000 a1???????? 33c4 898424e00b0000 53 }
            // n = 7, score = 400
            //   8bec                 | mov                 ebp, esp
            //   83e4f8               | and                 esp, 0xfffffff8
            //   81ece40b0000         | sub                 esp, 0xbe4
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   898424e00b0000       | mov                 dword ptr [esp + 0xbe0], eax
            //   53                   | push                ebx

        $sequence_6 = { 8d7c2428 50 f3a5 c684246401000000 }
            // n = 4, score = 400
            //   8d7c2428             | lea                 edi, [esp + 0x28]
            //   50                   | push                eax
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   c684246401000000     | mov                 byte ptr [esp + 0x164], 0

        $sequence_7 = { 33c0 888c045e010000 8a4c042c 40 }
            // n = 4, score = 400
            //   33c0                 | xor                 eax, eax
            //   888c045e010000       | mov                 byte ptr [esp + eax + 0x15e], cl
            //   8a4c042c             | mov                 cl, byte ptr [esp + eax + 0x2c]
            //   40                   | inc                 eax

        $sequence_8 = { 8b8c24ec0b0000 5f 5e 5b 33cc 33c0 e8???????? }
            // n = 7, score = 400
            //   8b8c24ec0b0000       | mov                 ecx, dword ptr [esp + 0xbec]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   33cc                 | xor                 ecx, esp
            //   33c0                 | xor                 eax, eax
            //   e8????????           |                     

        $sequence_9 = { ff15???????? 8b4c2410 51 ffd6 8b542414 52 ffd6 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   52                   | push                edx
            //   ffd6                 | call                esi

        $sequence_10 = { fe06 fe461e 3d68010000 7505 fe06 fe4e17 }
            // n = 6, score = 400
            //   fe06                 | inc                 byte ptr [esi]
            //   fe461e               | inc                 byte ptr [esi + 0x1e]
            //   3d68010000           | cmp                 eax, 0x168
            //   7505                 | jne                 7
            //   fe06                 | inc                 byte ptr [esi]
            //   fe4e17               | dec                 byte ptr [esi + 0x17]

        $sequence_11 = { 52 ffd6 6a0a ff15???????? }
            // n = 4, score = 400
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   6a0a                 | push                0xa
            //   ff15????????         |                     

        $sequence_12 = { 8b8df4feffff 6804010000 8d85f8feffff 50 6a01 }
            // n = 5, score = 200
            //   8b8df4feffff         | mov                 ecx, dword ptr [ebp - 0x10c]
            //   6804010000           | push                0x104
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_13 = { 8b95f4feffff 52 ff15???????? 8b4dfc 33cd 33c0 }
            // n = 6, score = 200
            //   8b95f4feffff         | mov                 edx, dword ptr [ebp - 0x10c]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   33c0                 | xor                 eax, eax

        $sequence_14 = { 51 6a00 ff15???????? 8d95f4feffff 52 6806000200 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d95f4feffff         | lea                 edx, [ebp - 0x10c]
            //   52                   | push                edx
            //   6806000200           | push                0x20006

        $sequence_15 = { 6a00 68???????? 6802000080 ff15???????? 85c0 752f }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   68????????           |                     
            //   6802000080           | push                0x80000002
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   752f                 | jne                 0x31

    condition:
        7 of them and filesize < 319488
}