rule win_flying_dutchman_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.flying_dutchman."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.flying_dutchman"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 899c2480400000 897c2418 3bc7 7d42 8b5c2410 e8???????? 8b5c2414 }
            // n = 7, score = 100
            //   899c2480400000       | mov                 dword ptr [esp + 0x4080], ebx
            //   897c2418             | mov                 dword ptr [esp + 0x18], edi
            //   3bc7                 | cmp                 eax, edi
            //   7d42                 | jge                 0x44
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   e8????????           |                     
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]

        $sequence_1 = { 8b5104 895008 8b09 894804 833801 }
            // n = 5, score = 100
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   833801               | cmp                 dword ptr [eax], 1

        $sequence_2 = { 83a588fdffff00 899d8cfdffff c68578fdffff00 c645fc05 ff15???????? 50 8d85e8fdffff }
            // n = 7, score = 100
            //   83a588fdffff00       | and                 dword ptr [ebp - 0x278], 0
            //   899d8cfdffff         | mov                 dword ptr [ebp - 0x274], ebx
            //   c68578fdffff00       | mov                 byte ptr [ebp - 0x288], 0
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]

        $sequence_3 = { 8b8574f7ffff 8985c0fdffff 8b8578f7ffff 8985c4fdffff 6804010000 8d858cf9ffff 50 }
            // n = 7, score = 100
            //   8b8574f7ffff         | mov                 eax, dword ptr [ebp - 0x88c]
            //   8985c0fdffff         | mov                 dword ptr [ebp - 0x240], eax
            //   8b8578f7ffff         | mov                 eax, dword ptr [ebp - 0x888]
            //   8985c4fdffff         | mov                 dword ptr [ebp - 0x23c], eax
            //   6804010000           | push                0x104
            //   8d858cf9ffff         | lea                 eax, [ebp - 0x674]
            //   50                   | push                eax

        $sequence_4 = { 83e800 747a 48 7459 48 0f858c000000 8b3d???????? }
            // n = 7, score = 100
            //   83e800               | sub                 eax, 0
            //   747a                 | je                  0x7c
            //   48                   | dec                 eax
            //   7459                 | je                  0x5b
            //   48                   | dec                 eax
            //   0f858c000000         | jne                 0x92
            //   8b3d????????         |                     

        $sequence_5 = { ff7508 e8???????? 8bd8 53 57 }
            // n = 5, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   53                   | push                ebx
            //   57                   | push                edi

        $sequence_6 = { 75f2 8b35???????? 57 57 ffd6 898570ffffff 3bc7 }
            // n = 7, score = 100
            //   75f2                 | jne                 0xfffffff4
            //   8b35????????         |                     
            //   57                   | push                edi
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   898570ffffff         | mov                 dword ptr [ebp - 0x90], eax
            //   3bc7                 | cmp                 eax, edi

        $sequence_7 = { 663bcf 75ed e9???????? 83f806 751a 33c0 }
            // n = 6, score = 100
            //   663bcf               | cmp                 cx, di
            //   75ed                 | jne                 0xffffffef
            //   e9????????           |                     
            //   83f806               | cmp                 eax, 6
            //   751a                 | jne                 0x1c
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { c1e606 03348560e90110 c745e401000000 33db 395e08 }
            // n = 5, score = 100
            //   c1e606               | shl                 esi, 6
            //   03348560e90110       | add                 esi, dword ptr [eax*4 + 0x1001e960]
            //   c745e401000000       | mov                 dword ptr [ebp - 0x1c], 1
            //   33db                 | xor                 ebx, ebx
            //   395e08               | cmp                 dword ptr [esi + 8], ebx

        $sequence_9 = { 3bf3 7405 e8???????? 6a05 ff15???????? 399d68deffff }
            // n = 6, score = 100
            //   3bf3                 | cmp                 esi, ebx
            //   7405                 | je                  7
            //   e8????????           |                     
            //   6a05                 | push                5
            //   ff15????????         |                     
            //   399d68deffff         | cmp                 dword ptr [ebp - 0x2198], ebx

    condition:
        7 of them and filesize < 276480
}