rule win_fobber_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fobber."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fobber"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b750c 8b4d10 39f7 760e }
            // n = 4, score = 1100
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   39f7                 | cmp                 edi, esi
            //   760e                 | jbe                 0x10

        $sequence_1 = { 57 51 8b7d08 30c0 31c9 f7d1 }
            // n = 6, score = 1100
            //   57                   | push                edi
            //   51                   | push                ecx
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   30c0                 | xor                 al, al
            //   31c9                 | xor                 ecx, ecx
            //   f7d1                 | not                 ecx

        $sequence_2 = { 8d0431 39f8 7607 49 01cf }
            // n = 5, score = 1100
            //   8d0431               | lea                 eax, [ecx + esi]
            //   39f8                 | cmp                 eax, edi
            //   7607                 | jbe                 9
            //   49                   | dec                 ecx
            //   01cf                 | add                 edi, ecx

        $sequence_3 = { 57 e8???????? 85c0 740f 89c1 }
            // n = 5, score = 1100
            //   57                   | push                edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   89c1                 | mov                 ecx, eax

        $sequence_4 = { 8d4d08 51 ff31 ffd0 }
            // n = 4, score = 1100
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   51                   | push                ecx
            //   ff31                 | push                dword ptr [ecx]
            //   ffd0                 | call                eax

        $sequence_5 = { 55 89e5 ff750c 6800300000 }
            // n = 4, score = 1100
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   6800300000           | push                0x3000

        $sequence_6 = { 0453 42 e2f6 59 }
            // n = 4, score = 1100
            //   0453                 | add                 al, 0x53
            //   42                   | inc                 edx
            //   e2f6                 | loop                0xfffffff8
            //   59                   | pop                 ecx

        $sequence_7 = { f2ae 31c0 e303 4f }
            // n = 4, score = 1100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   31c0                 | xor                 eax, eax
            //   e303                 | jecxz               5
            //   4f                   | dec                 edi

        $sequence_8 = { 8981efc00700 0081efe82300 0081c7371300 0081c7546900 0081c7397d00 00e9 }
            // n = 6, score = 100
            //   8981efc00700         | mov                 dword ptr [ecx + 0x7c0ef], eax
            //   0081efe82300         | add                 byte ptr [ecx + 0x23e8ef], al
            //   0081c7371300         | add                 byte ptr [ecx + 0x1337c7], al
            //   0081c7546900         | add                 byte ptr [ecx + 0x6954c7], al
            //   0081c7397d00         | add                 byte ptr [ecx + 0x7d39c7], al
            //   00e9                 | add                 cl, ch

        $sequence_9 = { 0f85196e0100 807dfc00 7407 8b4df8 836170fd 5e }
            // n = 6, score = 100
            //   0f85196e0100         | jne                 0x16e1f
            //   807dfc00             | cmp                 byte ptr [ebp - 4], 0
            //   7407                 | je                  9
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   836170fd             | and                 dword ptr [ecx + 0x70], 0xfffffffd
            //   5e                   | pop                 esi

        $sequence_10 = { 4d fc 02e9 5a a2???????? 92 b4ff }
            // n = 7, score = 100
            //   4d                   | dec                 ebp
            //   fc                   | cld                 
            //   02e9                 | add                 ch, cl
            //   5a                   | pop                 edx
            //   a2????????           |                     
            //   92                   | xchg                eax, edx
            //   b4ff                 | mov                 ah, 0xff

        $sequence_11 = { 0f8423050000 ff7508 e8???????? 59 59 8b4508 }
            // n = 6, score = 100
            //   0f8423050000         | je                  0x529
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_12 = { 43 7706 6205???????? 294a75 f2149c }
            // n = 5, score = 100
            //   43                   | inc                 ebx
            //   7706                 | ja                  8
            //   6205????????         |                     
            //   294a75               | sub                 dword ptr [edx + 0x75], ecx
            //   f2149c               | adc                 al, 0x9c

        $sequence_13 = { 6a52 686bb7ade9 e8???????? 83c408 }
            // n = 4, score = 100
            //   6a52                 | push                0x52
            //   686bb7ade9           | push                0xe9adb76b
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_14 = { 3bc3 7524 8b451c 3bc3 }
            // n = 4, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   7524                 | jne                 0x26
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   3bc3                 | cmp                 eax, ebx

        $sequence_15 = { 33db 57 3bcb 0f8499840100 3bf3 0f84a2840100 }
            // n = 6, score = 100
            //   33db                 | xor                 ebx, ebx
            //   57                   | push                edi
            //   3bcb                 | cmp                 ecx, ebx
            //   0f8499840100         | je                  0x1849f
            //   3bf3                 | cmp                 esi, ebx
            //   0f84a2840100         | je                  0x184a8

    condition:
        7 of them and filesize < 188416
}