rule win_fog_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fog."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fog"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a64 57 6a00 6800020000 e8???????? 0f1006 8b4514 }
            // n = 7, score = 100
            //   6a64                 | push                0x64
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6800020000           | push                0x200
            //   e8????????           |                     
            //   0f1006               | movups              xmm0, xmmword ptr [esi]
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_1 = { 50 8d45fc 50 8d45f0 50 ffd6 8b4510 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_2 = { 8b8db8f6ffff 85c9 7445 8b3c8dd42b0110 85ff 0f8588000000 33c0 }
            // n = 7, score = 100
            //   8b8db8f6ffff         | mov                 ecx, dword ptr [ebp - 0x948]
            //   85c9                 | test                ecx, ecx
            //   7445                 | je                  0x47
            //   8b3c8dd42b0110       | mov                 edi, dword ptr [ecx*4 + 0x10012bd4]
            //   85ff                 | test                edi, edi
            //   0f8588000000         | jne                 0x8e
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 83c40c 6b45e430 8945e0 8d8028a10110 8945e4 803800 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   6b45e430             | imul                eax, dword ptr [ebp - 0x1c], 0x30
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d8028a10110         | lea                 eax, [eax + 0x1001a128]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   803800               | cmp                 byte ptr [eax], 0

        $sequence_4 = { 83c408 8bd8 8b4720 6a00 56 53 6a10 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   8bd8                 | mov                 ebx, eax
            //   8b4720               | mov                 eax, dword ptr [edi + 0x20]
            //   6a00                 | push                0
            //   56                   | push                esi
            //   53                   | push                ebx
            //   6a10                 | push                0x10

        $sequence_5 = { 038c8300180000 0fb6c2 038c8300140000 0fb68308200000 038c8300100000 334cb338 314f38 }
            // n = 7, score = 100
            //   038c8300180000       | add                 ecx, dword ptr [ebx + eax*4 + 0x1800]
            //   0fb6c2               | movzx               eax, dl
            //   038c8300140000       | add                 ecx, dword ptr [ebx + eax*4 + 0x1400]
            //   0fb68308200000       | movzx               eax, byte ptr [ebx + 0x2008]
            //   038c8300100000       | add                 ecx, dword ptr [ebx + eax*4 + 0x1000]
            //   334cb338             | xor                 ecx, dword ptr [ebx + esi*4 + 0x38]
            //   314f38               | xor                 dword ptr [edi + 0x38], ecx

        $sequence_6 = { e8???????? 83c404 89861c020000 8b45e0 8d4e0c 6a06 8d901ca10110 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89861c020000         | mov                 dword ptr [esi + 0x21c], eax
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8d4e0c               | lea                 ecx, [esi + 0xc]
            //   6a06                 | push                6
            //   8d901ca10110         | lea                 edx, [eax + 0x1001a11c]

        $sequence_7 = { 0f8eac000000 660f1f440000 8d0c8500000000 83bc0d0cffffff02 0f857f000000 8db574ffffff 03f1 }
            // n = 7, score = 100
            //   0f8eac000000         | jle                 0xb2
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   8d0c8500000000       | lea                 ecx, [eax*4]
            //   83bc0d0cffffff02     | cmp                 dword ptr [ebp + ecx - 0xf4], 2
            //   0f857f000000         | jne                 0x85
            //   8db574ffffff         | lea                 esi, [ebp - 0x8c]
            //   03f1                 | add                 esi, ecx

        $sequence_8 = { 8b4604 03c3 50 ff36 e8???????? 8b4e04 }
            // n = 6, score = 100
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   03c3                 | add                 eax, ebx
            //   50                   | push                eax
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]

        $sequence_9 = { 0fb74004 6685c0 7527 ff4508 83c304 }
            // n = 5, score = 100
            //   0fb74004             | movzx               eax, word ptr [eax + 4]
            //   6685c0               | test                ax, ax
            //   7527                 | jne                 0x29
            //   ff4508               | inc                 dword ptr [ebp + 8]
            //   83c304               | add                 ebx, 4

    condition:
        7 of them and filesize < 244736
}