rule win_fonix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fonix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fonix"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a801 8b04d560b74900 8b14d564b74900 7506 83c002 83ea02 5d }
            // n = 7, score = 100
            //   a801                 | test                al, 1
            //   8b04d560b74900       | mov                 eax, dword ptr [edx*8 + 0x49b760]
            //   8b14d564b74900       | mov                 edx, dword ptr [edx*8 + 0x49b764]
            //   7506                 | jne                 8
            //   83c002               | add                 eax, 2
            //   83ea02               | sub                 edx, 2
            //   5d                   | pop                 ebp

        $sequence_1 = { 59 59 8b471c 89461c 8bc6 5f }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b471c               | mov                 eax, dword ptr [edi + 0x1c]
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi

        $sequence_2 = { c645fc18 8d4dc4 8bd0 c70424???????? e8???????? 59 8d8d44fcffff }
            // n = 7, score = 100
            //   c645fc18             | mov                 byte ptr [ebp - 4], 0x18
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   8bd0                 | mov                 edx, eax
            //   c70424????????       |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d8d44fcffff         | lea                 ecx, [ebp - 0x3bc]

        $sequence_3 = { 8b16 50 ff5220 e9???????? e8???????? 8b75ac 83c404 }
            // n = 7, score = 100
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   50                   | push                eax
            //   ff5220               | call                dword ptr [edx + 0x20]
            //   e9????????           |                     
            //   e8????????           |                     
            //   8b75ac               | mov                 esi, dword ptr [ebp - 0x54]
            //   83c404               | add                 esp, 4

        $sequence_4 = { 8985a0f8ffff 0f85c5fcffff 8b8d8cf8ffff 85c9 0f84d3000000 8b048d2cdc4900 89858cf8ffff }
            // n = 7, score = 100
            //   8985a0f8ffff         | mov                 dword ptr [ebp - 0x760], eax
            //   0f85c5fcffff         | jne                 0xfffffccb
            //   8b8d8cf8ffff         | mov                 ecx, dword ptr [ebp - 0x774]
            //   85c9                 | test                ecx, ecx
            //   0f84d3000000         | je                  0xd9
            //   8b048d2cdc4900       | mov                 eax, dword ptr [ecx*4 + 0x49dc2c]
            //   89858cf8ffff         | mov                 dword ptr [ebp - 0x774], eax

        $sequence_5 = { 50 8d8de0feffff e8???????? 8d8dc8feffff e8???????? 8d8db0feffff e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d8de0feffff         | lea                 ecx, [ebp - 0x120]
            //   e8????????           |                     
            //   8d8dc8feffff         | lea                 ecx, [ebp - 0x138]
            //   e8????????           |                     
            //   8d8db0feffff         | lea                 ecx, [ebp - 0x150]
            //   e8????????           |                     

        $sequence_6 = { 50 c745fc01000000 ff5248 ffb578ffffff 8d4e4c e8???????? ff7620 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   ff5248               | call                dword ptr [edx + 0x48]
            //   ffb578ffffff         | push                dword ptr [ebp - 0x88]
            //   8d4e4c               | lea                 ecx, [esi + 0x4c]
            //   e8????????           |                     
            //   ff7620               | push                dword ptr [esi + 0x20]

        $sequence_7 = { 83e3fe e8???????? 807d6700 0f8413010000 6a01 8d4dac e8???????? }
            // n = 7, score = 100
            //   83e3fe               | and                 ebx, 0xfffffffe
            //   e8????????           |                     
            //   807d6700             | cmp                 byte ptr [ebp + 0x67], 0
            //   0f8413010000         | je                  0x119
            //   6a01                 | push                1
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   e8????????           |                     

        $sequence_8 = { 8b45fc 0580000000 c5fe7f00 c5fe6f8560feffff c4e37d46458031 c5fe7f8580e5ffff c5fe6f8580e5ffff }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0580000000           | add                 eax, 0x80
            //   c5fe7f00             | vmovdqu             ymmword ptr [eax], ymm0
            //   c5fe6f8560feffff     | vmovdqu             ymm0, ymmword ptr [ebp - 0x1a0]
            //   c4e37d46458031       | vperm2i128          ymm0, ymm0, ymmword ptr [ebp - 0x80], 0x31
            //   c5fe7f8580e5ffff     | vmovdqu             ymmword ptr [ebp - 0x1a80], ymm0
            //   c5fe6f8580e5ffff     | vmovdqu             ymm0, ymmword ptr [ebp - 0x1a80]

        $sequence_9 = { 0f849c050000 6a01 8d8d50020000 e8???????? 6a01 8d4d8c c645fc0c }
            // n = 7, score = 100
            //   0f849c050000         | je                  0x5a2
            //   6a01                 | push                1
            //   8d8d50020000         | lea                 ecx, [ebp + 0x250]
            //   e8????????           |                     
            //   6a01                 | push                1
            //   8d4d8c               | lea                 ecx, [ebp - 0x74]
            //   c645fc0c             | mov                 byte ptr [ebp - 4], 0xc

    condition:
        7 of them and filesize < 2226176
}