rule win_former_first_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.former_first_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.former_first_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 898dd4feffff c785e0feffff02000000 899decfeffff 899d04ffffff 8d5001 8a08 40 }
            // n = 7, score = 200
            //   898dd4feffff         | mov                 dword ptr [ebp - 0x12c], ecx
            //   c785e0feffff02000000     | mov    dword ptr [ebp - 0x120], 2
            //   899decfeffff         | mov                 dword ptr [ebp - 0x114], ebx
            //   899d04ffffff         | mov                 dword ptr [ebp - 0xfc], ebx
            //   8d5001               | lea                 edx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax

        $sequence_1 = { 53 68???????? e8???????? 83c408 eb08 8bd8 899d08efffff }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   68????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   eb08                 | jmp                 0xa
            //   8bd8                 | mov                 ebx, eax
            //   899d08efffff         | mov                 dword ptr [ebp - 0x10f8], ebx

        $sequence_2 = { e8???????? 83c404 c744242800100000 6800100000 e8???????? 83c404 89442438 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c744242800100000     | mov                 dword ptr [esp + 0x28], 0x1000
            //   6800100000           | push                0x1000
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89442438             | mov                 dword ptr [esp + 0x38], eax

        $sequence_3 = { 7505 e8???????? 8b15???????? a1???????? 8b0d???????? 8995c8eeffff 8b15???????? }
            // n = 7, score = 200
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   8b15????????         |                     
            //   a1????????           |                     
            //   8b0d????????         |                     
            //   8995c8eeffff         | mov                 dword ptr [ebp - 0x1138], edx
            //   8b15????????         |                     

        $sequence_4 = { 83c40c 33c0 6803010000 8d8df8feffff }
            // n = 4, score = 200
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax
            //   6803010000           | push                0x103
            //   8d8df8feffff         | lea                 ecx, [ebp - 0x108]

        $sequence_5 = { c785d8feffff00000100 c7850cffffff00000000 89b5f8feffff 0f8455010000 8da42400000000 a1???????? 8b9508ffffff }
            // n = 7, score = 200
            //   c785d8feffff00000100     | mov    dword ptr [ebp - 0x128], 0x10000
            //   c7850cffffff00000000     | mov    dword ptr [ebp - 0xf4], 0
            //   89b5f8feffff         | mov                 dword ptr [ebp - 0x108], esi
            //   0f8455010000         | je                  0x15b
            //   8da42400000000       | lea                 esp, [esp]
            //   a1????????           |                     
            //   8b9508ffffff         | mov                 edx, dword ptr [ebp - 0xf8]

        $sequence_6 = { c745e400040000 837d1400 8b4ddc 8d55e4 8d0433 7415 6810040000 }
            // n = 7, score = 200
            //   c745e400040000       | mov                 dword ptr [ebp - 0x1c], 0x400
            //   837d1400             | cmp                 dword ptr [ebp + 0x14], 0
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8d55e4               | lea                 edx, [ebp - 0x1c]
            //   8d0433               | lea                 eax, [ebx + esi]
            //   7415                 | je                  0x17
            //   6810040000           | push                0x410

        $sequence_7 = { 83c404 89442468 3bc3 750d 68???????? }
            // n = 5, score = 200
            //   83c404               | add                 esp, 4
            //   89442468             | mov                 dword ptr [esp + 0x68], eax
            //   3bc3                 | cmp                 eax, ebx
            //   750d                 | jne                 0xf
            //   68????????           |                     

        $sequence_8 = { 413bc6 0f848d010000 488d542440 488d4c2450 ff15???????? }
            // n = 5, score = 100
            //   413bc6               | cmp                 eax, -2
            //   0f848d010000         | jbe                 7
            //   488d542440           | dec                 eax
            //   488d4c2450           | mov                 dword ptr [edi + 0x20], eax
            //   ff15????????         |                     

        $sequence_9 = { 488d8c24a0000000 e8???????? 4d85f6 751d }
            // n = 4, score = 100
            //   488d8c24a0000000     | lea                 ecx, [esp + 0x40]
            //   e8????????           |                     
            //   4d85f6               | nop                 
            //   751d                 | dec                 eax

        $sequence_10 = { e8???????? eb7a 4983f8fe 7605 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   eb7a                 | dec                 eax
            //   4983f8fe             | lea                 edx, [esp + 0x20]
            //   7605                 | nop                 

        $sequence_11 = { 4885f6 7456 488b4b08 4885c9 7444 }
            // n = 5, score = 100
            //   4885f6               | dec                 eax
            //   7456                 | mov                 ebx, dword ptr [esp + 0xa0]
            //   488b4b08             | inc                 ecx
            //   4885c9               | cmp                 eax, esi
            //   7444                 | je                  0x196

        $sequence_12 = { 48c783900000000f000000 c6437800 48837b6010 7209 488b4b48 }
            // n = 5, score = 100
            //   48c783900000000f000000     | dec    eax
            //   c6437800             | lea                 eax, [eax + ebx*4]
            //   48837b6010           | dec                 eax
            //   7209                 | mov                 dword ptr [edi + 0x28], eax
            //   488b4b48             | mov                 al, 1

        $sequence_13 = { 48894720 488d0498 48894728 b001 488b9c24a0000000 }
            // n = 5, score = 100
            //   48894720             | dec                 eax
            //   488d0498             | cmp                 dword ptr [esp + 0x40], 8
            //   48894728             | jb                  0x7d
            //   b001                 | jmp                 0x7c
            //   488b9c24a0000000     | dec                 ecx

        $sequence_14 = { 488d542420 e8???????? 90 48837c244008 7275 }
            // n = 5, score = 100
            //   488d542420           | lea                 ecx, [esp + 0xa0]
            //   e8????????           |                     
            //   90                   | dec                 ebp
            //   48837c244008         | test                esi, esi
            //   7275                 | jne                 0x1f

        $sequence_15 = { 488d942490020000 488d4c2440 e8???????? 90 }
            // n = 4, score = 100
            //   488d942490020000     | dec                 eax
            //   488d4c2440           | lea                 edx, [esp + 0x290]
            //   e8????????           |                     
            //   90                   | dec                 eax

    condition:
        7 of them and filesize < 626688
}