rule win_funksec_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.funksec."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.funksec"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4c8bb550020000 440fb68d58020000 48b80a00000000000080 4939c6 0f85a9020000 4489e1 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8bb550020000       | mov                 eax, dword ptr [ebp + 0x1148]
            //   440fb68d58020000     | mov                 edx, dword ptr [ebp + 0x114c]
            //   48b80a00000000000080     | dec    ecx
            //   4939c6               | cmp                 ecx, 4
            //   0f85a9020000         | dec                 esp
            //   4489e1               | mov                 ecx, dword ptr [ebp + 0x678]

        $sequence_1 = { e8???????? 66c7060101 c7460401000000 488d05b2591e00 48894608 48c7461001000000 0f57c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   66c7060101           | dec                 eax
            //   c7460401000000       | mov                 ecx, edx
            //   488d05b2591e00       | dec                 eax
            //   48894608             | mov                 edx, dword ptr [esp + 0x48]
            //   48c7461001000000     | dec                 esp
            //   0f57c0               | lea                 eax, [0x36d1e2]

        $sequence_2 = { e9???????? 488b8528110000 48898520110000 4c8d0564cf2c00 ba80000000 e8???????? e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b8528110000       | movzx               eax, word ptr [edx + edi*2]
            //   48898520110000       | dec                 esp
            //   4c8d0564cf2c00       | lea                 ebx, [edi + 1]
            //   ba80000000           | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_3 = { ba21000000 e8???????? 488d0ddb081100 4c8d056c091100 ba1f000000 e8???????? 488d0d73091100 }
            // n = 7, score = 100
            //   ba21000000           | jmp                 0xc95
            //   e8????????           |                     
            //   488d0ddb081100       | mov                 ecx, 8
            //   4c8d056c091100       | mov                 edx, 0x18
            //   ba1f000000           | jmp                 0xc90
            //   e8????????           |                     
            //   488d0d73091100       | mov                 edx, 0x18

        $sequence_4 = { e8???????? 84c0 89fb 0f84f6000000 488b0d???????? 488b4138 4885c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | dec                 eax
            //   89fb                 | mov                 ecx, dword ptr [eax]
            //   0f84f6000000         | dec                 eax
            //   488b0d????????       |                     
            //   488b4138             | mov                 eax, dword ptr [ecx + 0x38]
            //   4885c0               | dec                 eax

        $sequence_5 = { e9???????? 4489f0 83e01f 410fb65701 83e23f 4180fedf 7664 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4489f0               | mov                 edx, eax
            //   83e01f               | dec                 ecx
            //   410fb65701           | mov                 eax, esi
            //   83e23f               | inc                 ecx
            //   4180fedf             | mov                 ebp, 8
            //   7664                 | inc                 ebp

        $sequence_6 = { e9???????? 488d05f6d11400 488985a0000000 48c785a800000001000000 48c785b000000008000000 0f57c0 0f1185b8000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d05f6d11400       | jmp                 0x290
            //   488985a0000000       | dec                 ecx
            //   48c785a800000001000000     | mov    dword ptr [edi + 0x20], eax
            //   48c785b000000008000000     | jmp    0x266
            //   0f57c0               | dec                 eax
            //   0f1185b8000000       | mov                 ecx, dword ptr [ebp + 0xd0]

        $sequence_7 = { e8???????? ebde 498b07 4885c0 0f84c3010000 48c1e003 488d1440 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ebde                 | mov                 dword ptr [ebp - 8], 0
            //   498b07               | dec                 eax
            //   4885c0               | mov                 edx, dword ptr [esi + 0x48]
            //   0f84c3010000         | dec                 eax
            //   48c1e003             | test                edx, edx
            //   488d1440             | jmp                 0xffffffeb

        $sequence_8 = { e8???????? 4c8bad30360000 4d8db518010000 41b828030000 4c89f1 4889da e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8bad30360000       | dec                 esp
            //   4d8db518010000       | mov                 dword ptr [ebp + 0x940], eax
            //   41b828030000         | inc                 ecx
            //   4c89f1               | mov                 ecx, 3
            //   4889da               | dec                 esp
            //   e8????????           |                     

        $sequence_9 = { ebd0 49ffc3 49ffc9 4d8918 4d894808 488d05cdf81000 488945d8 }
            // n = 7, score = 100
            //   ebd0                 | mov                 dword ptr [esi + 0x40], ebp
            //   49ffc3               | dec                 eax
            //   49ffc9               | add                 esp, 0x28
            //   4d8918               | pop                 ebx
            //   4d894808             | pop                 ebp
            //   488d05cdf81000       | pop                 edi
            //   488945d8             | pop                 esi

    condition:
        7 of them and filesize < 10986496
}