rule win_funny_dream_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.funny_dream."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.funny_dream"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8bd8 c745f025735c2a 56 8d45f0 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   c745f025735c2a       | mov                 dword ptr [ebp - 0x10], 0x2a5c7325
            //   56                   | push                esi
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_1 = { 8d7f01 88443bff 84c0 75f3 8b4df8 }
            // n = 5, score = 300
            //   8d7f01               | lea                 edi, [edi + 1]
            //   88443bff             | mov                 byte ptr [ebx + edi - 1], al
            //   84c0                 | test                al, al
            //   75f3                 | jne                 0xfffffff5
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_2 = { 50 8d4701 c785e0f5ffff0a000000 50 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   8d4701               | lea                 eax, [edi + 1]
            //   c785e0f5ffff0a000000     | mov    dword ptr [ebp - 0xa20], 0xa
            //   50                   | push                eax

        $sequence_3 = { 50 e8???????? 68ff010000 8d85fdfdffff 6a00 }
            // n = 5, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   68ff010000           | push                0x1ff
            //   8d85fdfdffff         | lea                 eax, [ebp - 0x203]
            //   6a00                 | push                0

        $sequence_4 = { f3a4 50 e8???????? 8b742414 83c408 85c0 748d }
            // n = 7, score = 300
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   748d                 | je                  0xffffff8f

        $sequence_5 = { 83bdacfeffff00 744b 8d85a0feffff c785a0feffff00010000 50 ffb59cfeffff }
            // n = 6, score = 300
            //   83bdacfeffff00       | cmp                 dword ptr [ebp - 0x154], 0
            //   744b                 | je                  0x4d
            //   8d85a0feffff         | lea                 eax, [ebp - 0x160]
            //   c785a0feffff00010000     | mov    dword ptr [ebp - 0x160], 0x100
            //   50                   | push                eax
            //   ffb59cfeffff         | push                dword ptr [ebp - 0x164]

        $sequence_6 = { 57 8bf9 6a00 8db750100000 56 ff15???????? 85c0 }
            // n = 7, score = 300
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   6a00                 | push                0
            //   8db750100000         | lea                 esi, [edi + 0x1050]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 56 8b7508 57 8b3d???????? 6aff ff7608 ffd7 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   6aff                 | push                -1
            //   ff7608               | push                dword ptr [esi + 8]
            //   ffd7                 | call                edi

        $sequence_8 = { 53 8a4810 8d4602 50 884e01 e8???????? 8b4508 }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   8a4810               | mov                 cl, byte ptr [eax + 0x10]
            //   8d4602               | lea                 eax, [esi + 2]
            //   50                   | push                eax
            //   884e01               | mov                 byte ptr [esi + 1], cl
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_9 = { 0f118424e0000000 0f10842458010000 0f118424f0000000 e8???????? 898424c8000000 8b4508 }
            // n = 6, score = 300
            //   0f118424e0000000     | movups              xmmword ptr [esp + 0xe0], xmm0
            //   0f10842458010000     | movups              xmm0, xmmword ptr [esp + 0x158]
            //   0f118424f0000000     | movups              xmmword ptr [esp + 0xf0], xmm0
            //   e8????????           |                     
            //   898424c8000000       | mov                 dword ptr [esp + 0xc8], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 393216
}