rule win_gacrux_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gacrux."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gacrux"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c9 743c 6548 8b0425???????? 80780201 7428 48 }
            // n = 7, score = 300
            //   85c9                 | test                ecx, ecx
            //   743c                 | je                  0x3e
            //   6548                 | dec                 eax
            //   8b0425????????       |                     
            //   80780201             | cmp                 byte ptr [eax + 2], 1
            //   7428                 | je                  0x2a
            //   48                   | dec                 eax

        $sequence_1 = { 33db e8???????? 48 8bf8 48 85c0 742f }
            // n = 7, score = 300
            //   33db                 | xor                 ebx, ebx
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8bf8                 | mov                 edi, eax
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   742f                 | je                  0x31

        $sequence_2 = { 3900 75f4 48 63c2 85d2 740a 48 }
            // n = 7, score = 300
            //   3900                 | cmp                 dword ptr [eax], eax
            //   75f4                 | jne                 0xfffffff6
            //   48                   | dec                 eax
            //   63c2                 | arpl                dx, ax
            //   85d2                 | test                edx, edx
            //   740a                 | je                  0xc
            //   48                   | dec                 eax

        $sequence_3 = { 740b 41 81cb00900000 45 895821 40 f6c610 }
            // n = 7, score = 300
            //   740b                 | je                  0xd
            //   41                   | inc                 ecx
            //   81cb00900000         | or                  ebx, 0x9000
            //   45                   | inc                 ebp
            //   895821               | mov                 dword ptr [eax + 0x21], ebx
            //   40                   | inc                 eax
            //   f6c610               | test                dh, 0x10

        $sequence_4 = { e8???????? 4c 8bc3 33d2 48 8bcf ffd0 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   4c                   | dec                 esp
            //   8bc3                 | mov                 eax, ebx
            //   33d2                 | xor                 edx, edx
            //   48                   | dec                 eax
            //   8bcf                 | mov                 ecx, edi
            //   ffd0                 | call                eax

        $sequence_5 = { 3c40 755f 41 0fbaea1e 40 8ac7 c0e803 }
            // n = 7, score = 300
            //   3c40                 | cmp                 al, 0x40
            //   755f                 | jne                 0x61
            //   41                   | inc                 ecx
            //   0fbaea1e             | bts                 edx, 0x1e
            //   40                   | inc                 eax
            //   8ac7                 | mov                 al, bh
            //   c0e803               | shr                 al, 3

        $sequence_6 = { 0fb6c3 44 3bc8 0f850f010000 44 0fb66d67 43 }
            // n = 7, score = 300
            //   0fb6c3               | movzx               eax, bl
            //   44                   | inc                 esp
            //   3bc8                 | cmp                 ecx, eax
            //   0f850f010000         | jne                 0x115
            //   44                   | inc                 esp
            //   0fb66d67             | movzx               ebp, byte ptr [ebp + 0x67]
            //   43                   | inc                 ebx

        $sequence_7 = { 75f6 e8???????? 48 83c428 c3 48 }
            // n = 6, score = 300
            //   75f6                 | jne                 0xfffffff8
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   83c428               | add                 esp, 0x28
            //   c3                   | ret                 
            //   48                   | dec                 eax

        $sequence_8 = { eb02 33db 8b4c2460 0337 392f 75a5 eb5d }
            // n = 7, score = 300
            //   eb02                 | jmp                 4
            //   33db                 | xor                 ebx, ebx
            //   8b4c2460             | mov                 ecx, dword ptr [esp + 0x60]
            //   0337                 | add                 esi, dword ptr [edi]
            //   392f                 | cmp                 dword ptr [edi], ebp
            //   75a5                 | jne                 0xffffffa7
            //   eb5d                 | jmp                 0x5f

        $sequence_9 = { 83e801 7463 83e801 7457 83e802 744b }
            // n = 6, score = 300
            //   83e801               | sub                 eax, 1
            //   7463                 | je                  0x65
            //   83e801               | sub                 eax, 1
            //   7457                 | je                  0x59
            //   83e802               | sub                 eax, 2
            //   744b                 | je                  0x4d

    condition:
        7 of them and filesize < 122880
}