rule win_gameover_dga_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gameover_dga."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gameover_dga"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 884617 33c0 40 e9???????? 8a4601 33db 8b6c2434 }
            // n = 7, score = 700
            //   884617               | mov                 byte ptr [esi + 0x17], al
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   e9????????           |                     
            //   8a4601               | mov                 al, byte ptr [esi + 1]
            //   33db                 | xor                 ebx, ebx
            //   8b6c2434             | mov                 ebp, dword ptr [esp + 0x34]

        $sequence_1 = { 8b13 8bcb 6a01 57 56 ff742420 ff742420 }
            // n = 7, score = 700
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   8bcb                 | mov                 ecx, ebx
            //   6a01                 | push                1
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   ff742420             | push                dword ptr [esp + 0x20]

        $sequence_2 = { 8bf8 83cdff 3bfd 7504 8bc5 eb42 }
            // n = 6, score = 700
            //   8bf8                 | mov                 edi, eax
            //   83cdff               | or                  ebp, 0xffffffff
            //   3bfd                 | cmp                 edi, ebp
            //   7504                 | jne                 6
            //   8bc5                 | mov                 eax, ebp
            //   eb42                 | jmp                 0x44

        $sequence_3 = { 55 8bac2434010000 56 57 8bf9 8b4508 85c0 }
            // n = 7, score = 700
            //   55                   | push                ebp
            //   8bac2434010000       | mov                 ebp, dword ptr [esp + 0x134]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   85c0                 | test                eax, eax

        $sequence_4 = { 39442414 0f85eb060000 8b84245c010000 41 894c2420 40 50 }
            // n = 7, score = 700
            //   39442414             | cmp                 dword ptr [esp + 0x14], eax
            //   0f85eb060000         | jne                 0x6f1
            //   8b84245c010000       | mov                 eax, dword ptr [esp + 0x15c]
            //   41                   | inc                 ecx
            //   894c2420             | mov                 dword ptr [esp + 0x20], ecx
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_5 = { 85db 7417 6af6 6a01 ff742434 ffd3 85c0 }
            // n = 7, score = 700
            //   85db                 | test                ebx, ebx
            //   7417                 | je                  0x19
            //   6af6                 | push                -0xa
            //   6a01                 | push                1
            //   ff742434             | push                dword ptr [esp + 0x34]
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax

        $sequence_6 = { ff7064 ffd6 85c0 0f8513010000 a1???????? 68???????? ff7064 }
            // n = 7, score = 700
            //   ff7064               | push                dword ptr [eax + 0x64]
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f8513010000         | jne                 0x119
            //   a1????????           |                     
            //   68????????           |                     
            //   ff7064               | push                dword ptr [eax + 0x64]

        $sequence_7 = { 8b4c2424 b301 8901 5d 8bce e8???????? }
            // n = 6, score = 700
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   b301                 | mov                 bl, 1
            //   8901                 | mov                 dword ptr [ecx], eax
            //   5d                   | pop                 ebp
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_8 = { 8bc2 83c204 3b54241c 7725 8a5c2428 8818 8a5c2413 }
            // n = 7, score = 700
            //   8bc2                 | mov                 eax, edx
            //   83c204               | add                 edx, 4
            //   3b54241c             | cmp                 edx, dword ptr [esp + 0x1c]
            //   7725                 | ja                  0x27
            //   8a5c2428             | mov                 bl, byte ptr [esp + 0x28]
            //   8818                 | mov                 byte ptr [eax], bl
            //   8a5c2413             | mov                 bl, byte ptr [esp + 0x13]

        $sequence_9 = { 0f851f010000 8b442414 8d542428 52 53 ff742450 8b08 }
            // n = 7, score = 700
            //   0f851f010000         | jne                 0x125
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   52                   | push                edx
            //   53                   | push                ebx
            //   ff742450             | push                dword ptr [esp + 0x50]
            //   8b08                 | mov                 ecx, dword ptr [eax]

    condition:
        7 of them and filesize < 540672
}