rule win_gaudox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gaudox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gaudox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5f 5e 8be5 5d c20400 8b7c240c 8d44244c }
            // n = 7, score = 200
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8b7c240c             | mov                 edi, dword ptr [esp + 0xc]
            //   8d44244c             | lea                 eax, [esp + 0x4c]

        $sequence_1 = { 50 e8???????? a1???????? 8bb858010000 83ff20 772c 68???????? }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   a1????????           |                     
            //   8bb858010000         | mov                 edi, dword ptr [eax + 0x158]
            //   83ff20               | cmp                 edi, 0x20
            //   772c                 | ja                  0x2e
            //   68????????           |                     

        $sequence_2 = { 745c 85d2 7458 56 8b7508 85f6 }
            // n = 6, score = 200
            //   745c                 | je                  0x5e
            //   85d2                 | test                edx, edx
            //   7458                 | je                  0x5a
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   85f6                 | test                esi, esi

        $sequence_3 = { 660f7f842460030000 660f7f842470030000 660f7f842480030000 f3ab b982000000 89842460060000 }
            // n = 6, score = 200
            //   660f7f842460030000     | movdqa    xmmword ptr [esp + 0x360], xmm0
            //   660f7f842470030000     | movdqa    xmmword ptr [esp + 0x370], xmm0
            //   660f7f842480030000     | movdqa    xmmword ptr [esp + 0x380], xmm0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   b982000000           | mov                 ecx, 0x82
            //   89842460060000       | mov                 dword ptr [esp + 0x660], eax

        $sequence_4 = { 8b4708 2bca 83c0fb 03c1 894201 8d45c4 }
            // n = 6, score = 200
            //   8b4708               | mov                 eax, dword ptr [edi + 8]
            //   2bca                 | sub                 ecx, edx
            //   83c0fb               | add                 eax, -5
            //   03c1                 | add                 eax, ecx
            //   894201               | mov                 dword ptr [edx + 1], eax
            //   8d45c4               | lea                 eax, [ebp - 0x3c]

        $sequence_5 = { 8bc1 b9???????? 50 e8???????? 8b4c2440 8bc1 803900 }
            // n = 7, score = 200
            //   8bc1                 | mov                 eax, ecx
            //   b9????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   8bc1                 | mov                 eax, ecx
            //   803900               | cmp                 byte ptr [ecx], 0

        $sequence_6 = { 8d8548feffff 50 e8???????? a1???????? 8bb888010000 83ff1c 7731 }
            // n = 7, score = 200
            //   8d8548feffff         | lea                 eax, [ebp - 0x1b8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   a1????????           |                     
            //   8bb888010000         | mov                 edi, dword ptr [eax + 0x188]
            //   83ff1c               | cmp                 edi, 0x1c
            //   7731                 | ja                  0x33

        $sequence_7 = { 0f88ce000000 8b15???????? b8???????? ff7750 8b7c2450 2bc2 8944245c }
            // n = 7, score = 200
            //   0f88ce000000         | js                  0xd4
            //   8b15????????         |                     
            //   b8????????           |                     
            //   ff7750               | push                dword ptr [edi + 0x50]
            //   8b7c2450             | mov                 edi, dword ptr [esp + 0x50]
            //   2bc2                 | sub                 eax, edx
            //   8944245c             | mov                 dword ptr [esp + 0x5c], eax

        $sequence_8 = { 6a01 e8???????? 8b55fc 8bc8 8b45f4 890c82 85c9 }
            // n = 7, score = 200
            //   6a01                 | push                1
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8bc8                 | mov                 ecx, eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   890c82               | mov                 dword ptr [edx + eax*4], ecx
            //   85c9                 | test                ecx, ecx

        $sequence_9 = { 731a 8bd1 b9???????? e8???????? 85c0 0f88a7000000 8b74240c }
            // n = 7, score = 200
            //   731a                 | jae                 0x1c
            //   8bd1                 | mov                 edx, ecx
            //   b9????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f88a7000000         | js                  0xad
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]

    condition:
        7 of them and filesize < 155648
}