rule win_gazer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gazer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gazer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 7511 e8???????? 84c0 7508 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   85c0                 | sub                 esp, 0x1c
            //   7511                 | push                esi
            //   e8????????           |                     
            //   84c0                 | push                dword ptr [esp + 0x24]
            //   7508                 | mov                 esi, ecx

        $sequence_1 = { ff15???????? 85c0 7511 e8???????? 84c0 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   85c0                 | je                  0x165
            //   7511                 | test                al, al
            //   e8????????           |                     
            //   84c0                 | mov                 ecx, edi

        $sequence_2 = { 85c0 7511 e8???????? 84c0 }
            // n = 4, score = 300
            //   85c0                 | lea                 eax, [esp + 8]
            //   7511                 | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   84c0                 | je                  0xc10

        $sequence_3 = { 85c0 7511 e8???????? 84c0 7508 83c8ff e9???????? }
            // n = 7, score = 300
            //   85c0                 | mov                 edx, dword ptr [esi + 0x20]
            //   7511                 | dec                 eax
            //   e8????????           |                     
            //   84c0                 | lea                 ecx, [edx + eax*2 + 2]
            //   7508                 | dec                 eax
            //   83c8ff               | mov                 dword ptr [esi + 0x28], ecx
            //   e9????????           |                     

        $sequence_4 = { ff15???????? 85c0 7511 e8???????? 84c0 7508 83c8ff }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   85c0                 | push                0xc
            //   7511                 | cmp                 dword ptr [esp + 8], 0
            //   e8????????           |                     
            //   84c0                 | pop                 ecx
            //   7508                 | mov                 ecx, dword ptr [esp + 4]
            //   83c8ff               | jne                 0x1f4b

        $sequence_5 = { 85c0 7511 e8???????? 84c0 7508 83c8ff }
            // n = 6, score = 300
            //   85c0                 | mov                 edx, 0x543
            //   7511                 | dec                 eax
            //   e8????????           |                     
            //   84c0                 | mov                 ecx, ebx
            //   7508                 | dec                 esp
            //   83c8ff               | mov                 dword ptr [ebp + 0x58], edi

        $sequence_6 = { 85c0 7511 e8???????? 84c0 7508 }
            // n = 5, score = 300
            //   85c0                 | push                0x800
            //   7511                 | push                8
            //   e8????????           |                     
            //   84c0                 | push                dword ptr [eax]
            //   7508                 | mov                 ecx, dword ptr [ebp + 0x14]

        $sequence_7 = { 7511 e8???????? 84c0 7508 83c8ff e9???????? }
            // n = 6, score = 300
            //   7511                 | mov                 edi, ecx
            //   e8????????           |                     
            //   84c0                 | dec                 eax
            //   7508                 | mov                 esi, eax
            //   83c8ff               | dec                 eax
            //   e9????????           |                     

        $sequence_8 = { 7511 e8???????? 84c0 7508 83c8ff }
            // n = 5, score = 300
            //   7511                 | mov                 ecx, edi
            //   e8????????           |                     
            //   84c0                 | dec                 ebp
            //   7508                 | test                eax, eax
            //   83c8ff               | je                  0x32f

        $sequence_9 = { 41c1ca0b 4503d1 410bc2 4133c1 4103c0 }
            // n = 5, score = 200
            //   41c1ca0b             | xor                 ecx, ecx
            //   4503d1               | lea                 eax, [eax + esi + 0x18]
            //   410bc2               | cmp                 cx, word ptr [esi + 6]
            //   4133c1               | movzx               eax, word ptr [esi + 0x14]
            //   4103c0               | and                 dword ptr [ebp - 0x10], 0

    condition:
        7 of them and filesize < 950272
}