rule win_gcman_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gcman."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gcman"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 01d9 89de 31c6 21ce 31c6 0375c4 01f2 }
            // n = 7, score = 100
            //   01d9                 | add                 ecx, ebx
            //   89de                 | mov                 esi, ebx
            //   31c6                 | xor                 esi, eax
            //   21ce                 | and                 esi, ecx
            //   31c6                 | xor                 esi, eax
            //   0375c4               | add                 esi, dword ptr [ebp - 0x3c]
            //   01f2                 | add                 edx, esi

        $sequence_1 = { 8d45d4 89442408 c744240413000020 8b45e4 890424 e8???????? }
            // n = 6, score = 100
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c744240413000020     | mov                 dword ptr [esp + 4], 0x20000013
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_2 = { 89ce 31de 21c6 31de 0375a8 }
            // n = 5, score = 100
            //   89ce                 | mov                 esi, ecx
            //   31de                 | xor                 esi, ebx
            //   21c6                 | and                 esi, eax
            //   31de                 | xor                 esi, ebx
            //   0375a8               | add                 esi, dword ptr [ebp - 0x58]

        $sequence_3 = { 31c6 0375b4 01f1 81e979f22a0b c1c10e 01d9 }
            // n = 6, score = 100
            //   31c6                 | xor                 esi, eax
            //   0375b4               | add                 esi, dword ptr [ebp - 0x4c]
            //   01f1                 | add                 ecx, esi
            //   81e979f22a0b         | sub                 ecx, 0xb2af279
            //   c1c10e               | rol                 ecx, 0xe
            //   01d9                 | add                 ecx, ebx

        $sequence_4 = { 89442408 8b4510 89442404 8b45e8 890424 e8???????? }
            // n = 6, score = 100
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_5 = { 8b4508 40 0fb600 c0e804 240f 0202 8801 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   40                   | inc                 eax
            //   0fb600               | movzx               eax, byte ptr [eax]
            //   c0e804               | shr                 al, 4
            //   240f                 | and                 al, 0xf
            //   0202                 | add                 al, byte ptr [edx]
            //   8801                 | mov                 byte ptr [ecx], al

        $sequence_6 = { c1e818 8802 8b550c 83c254 8b450c 8b4014 }
            // n = 6, score = 100
            //   c1e818               | shr                 eax, 0x18
            //   8802                 | mov                 byte ptr [edx], al
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   83c254               | add                 edx, 0x54
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4014               | mov                 eax, dword ptr [eax + 0x14]

        $sequence_7 = { 40 8945f4 eb0c 8d45e0 }
            // n = 4, score = 100
            //   40                   | inc                 eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   eb0c                 | jmp                 0xe
            //   8d45e0               | lea                 eax, [ebp - 0x20]

        $sequence_8 = { 01c3 89de 31c6 31d6 0375d4 01f1 81c122619d6d }
            // n = 7, score = 100
            //   01c3                 | add                 ebx, eax
            //   89de                 | mov                 esi, ebx
            //   31c6                 | xor                 esi, eax
            //   31d6                 | xor                 esi, edx
            //   0375d4               | add                 esi, dword ptr [ebp - 0x2c]
            //   01f1                 | add                 ecx, esi
            //   81c122619d6d         | add                 ecx, 0x6d9d6122

        $sequence_9 = { 890424 e8???????? 8b45ec 8945f4 8b45f4 803800 741f }
            // n = 7, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   803800               | cmp                 byte ptr [eax], 0
            //   741f                 | je                  0x21

    condition:
        7 of them and filesize < 81920
}