rule win_gearshift_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gearshift."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gearshift"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883ec20 85c9 7871 3b0d???????? 7369 4863d9 488d2dff1a0300 }
            // n = 7, score = 200
            //   4883ec20             | inc                 edx
            //   85c9                 | movzx               eax, byte ptr [eax + ebp]
            //   7871                 | and                 al, 7
            //   3b0d????????         |                     
            //   7369                 | cmp                 al, 5
            //   4863d9               | jne                 0xddc
            //   488d2dff1a0300       | inc                 ecx

        $sequence_1 = { 48895c2408 4889742410 48897c2418 498bf8 8bda 488bf1 443bca }
            // n = 7, score = 200
            //   48895c2408           | mov                 dword ptr [esp + 0x1b0], eax
            //   4889742410           | dec                 eax
            //   48897c2418           | mov                 edi, edx
            //   498bf8               | xor                 edx, edx
            //   8bda                 | mov                 ebx, ecx
            //   488bf1               | dec                 eax
            //   443bca               | lea                 ecx, [esp + 0x41]

        $sequence_2 = { e8???????? e9???????? 488b442450 488d0db7350300 488b04c1 41f644070840 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   e9????????           |                     
            //   488b442450           | dec                 eax
            //   488d0db7350300       | add                 ecx, 0x60
            //   488b04c1             | mov                 ecx, 0x30
            //   41f644070840         | dec                 esp

        $sequence_3 = { 4883c310 48ffce 75d4 488d1def070300 }
            // n = 4, score = 200
            //   4883c310             | lea                 eax, [esp + 0x58]
            //   48ffce               | dec                 esp
            //   75d4                 | lea                 ecx, [esi + 0x24]
            //   488d1def070300       | inc                 ebp

        $sequence_4 = { 8b4ffc 41b940000000 41b800100000 488bd0 4903ce 488bd8 }
            // n = 6, score = 200
            //   8b4ffc               | test                esi, esi
            //   41b940000000         | je                  0x890
            //   41b800100000         | push                edi
            //   488bd0               | mov                 edi, edx
            //   4903ce               | sub                 edi, ecx
            //   488bd8               | mov                 edi, edi

        $sequence_5 = { 488b4c2430 4885c9 7406 ff15???????? 8bc7 eb02 }
            // n = 6, score = 200
            //   488b4c2430           | mov                 eax, dword ptr [esp + 8]
            //   4885c9               | dec                 eax
            //   7406                 | add                 eax, 1
            //   ff15????????         |                     
            //   8bc7                 | dec                 eax
            //   eb02                 | mov                 dword ptr [esp + 8], eax

        $sequence_6 = { e8???????? 33c9 3d00040000 7510 e8???????? b801000000 4883c430 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   33c9                 | dec                 eax
            //   3d00040000           | add                 eax, ecx
            //   7510                 | dec                 eax
            //   e8????????           |                     
            //   b801000000           | mov                 dword ptr [esp + 0x88], eax
            //   4883c430             | dec                 eax

        $sequence_7 = { 4883c328 0fb74806 443bf9 0f8c50ffffff 488b4500 8b4828 }
            // n = 6, score = 200
            //   4883c328             | dec                 eax
            //   0fb74806             | mov                 dword ptr [esp + 8], ebx
            //   443bf9               | push                edi
            //   0f8c50ffffff         | dec                 eax
            //   488b4500             | sub                 esp, 0x20
            //   8b4828               | dec                 eax

        $sequence_8 = { 0f84ca020000 488d05d13b0300 4a8b04e0 41f644070880 0f84b3020000 e8???????? 33db }
            // n = 7, score = 200
            //   0f84ca020000         | inc                 ecx
            //   488d05d13b0300       | mov                 eax, 0x258
            //   4a8b04e0             | dec                 eax
            //   41f644070880         | lea                 ecx, [ebp + 0x3e1]
            //   0f84b3020000         | xor                 edx, edx
            //   e8????????           |                     
            //   33db                 | inc                 ecx

        $sequence_9 = { 488d542434 8bc8 ff15???????? 33c0 488d542438 }
            // n = 5, score = 200
            //   488d542434           | dec                 eax
            //   8bc8                 | lea                 edx, [0x3fa0]
            //   ff15????????         |                     
            //   33c0                 | dec                 eax
            //   488d542438           | mov                 ecx, esi

    condition:
        7 of them and filesize < 540672
}