rule win_get2_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.get2."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.get2"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b4508 8be5 5d c20400 68d0000000 b8???????? }
            // n = 7, score = 1000
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   68d0000000           | push                0xd0
            //   b8????????           |                     

        $sequence_1 = { 0f849e000000 807d0c00 0f859a000000 f6c104 }
            // n = 4, score = 1000
            //   0f849e000000         | je                  0xa4
            //   807d0c00             | cmp                 byte ptr [ebp + 0xc], 0
            //   0f859a000000         | jne                 0xa0
            //   f6c104               | test                cl, 4

        $sequence_2 = { 8bf1 8975d0 33ff 8975cc }
            // n = 4, score = 1000
            //   8bf1                 | mov                 esi, ecx
            //   8975d0               | mov                 dword ptr [ebp - 0x30], esi
            //   33ff                 | xor                 edi, edi
            //   8975cc               | mov                 dword ptr [ebp - 0x34], esi

        $sequence_3 = { 8b4508 660f6ec1 f30fe6c0 c1e91f 51 51 660f6ec8 }
            // n = 7, score = 1000
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   660f6ec1             | movd                xmm0, ecx
            //   f30fe6c0             | cvtdq2pd            xmm0, xmm0
            //   c1e91f               | shr                 ecx, 0x1f
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   660f6ec8             | movd                xmm1, eax

        $sequence_4 = { 8d55d8 8d8d24ffffff e8???????? 59 8bc8 }
            // n = 5, score = 1000
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   8d8d24ffffff         | lea                 ecx, [ebp - 0xdc]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bc8                 | mov                 ecx, eax

        $sequence_5 = { 83e017 89410c 8b4910 23c8 0f849e000000 807d0c00 }
            // n = 6, score = 1000
            //   83e017               | and                 eax, 0x17
            //   89410c               | mov                 dword ptr [ecx + 0xc], eax
            //   8b4910               | mov                 ecx, dword ptr [ecx + 0x10]
            //   23c8                 | and                 ecx, eax
            //   0f849e000000         | je                  0xa4
            //   807d0c00             | cmp                 byte ptr [ebp + 0xc], 0

        $sequence_6 = { 895dfc e8???????? c645fc02 eb0b 8d45d8 }
            // n = 5, score = 1000
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   e8????????           |                     
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   eb0b                 | jmp                 0xd
            //   8d45d8               | lea                 eax, [ebp - 0x28]

        $sequence_7 = { 897e04 897e08 33db c745ec07000000 }
            // n = 4, score = 1000
            //   897e04               | mov                 dword ptr [esi + 4], edi
            //   897e08               | mov                 dword ptr [esi + 8], edi
            //   33db                 | xor                 ebx, ebx
            //   c745ec07000000       | mov                 dword ptr [ebp - 0x14], 7

        $sequence_8 = { 488d7b38 488d05a6020200 483947f0 741a 488b0f 4885c9 }
            // n = 6, score = 100
            //   488d7b38             | dec                 eax
            //   488d05a6020200       | mov                 ebx, ecx
            //   483947f0             | dec                 eax
            //   741a                 | mov                 dword ptr [ecx], eax
            //   488b0f               | test                dl, 1
            //   4885c9               | je                  0x27

        $sequence_9 = { 4863c8 488b4308 48894cd008 483b6b10 0f83ba010000 }
            // n = 5, score = 100
            //   4863c8               | jb                  0xd
            //   488b4308             | mov                 ebx, 2
            //   48894cd008           | mov                 dword ptr [esp + 0x20], ebx
            //   483b6b10             | dec                 eax
            //   0f83ba010000         | lea                 eax, [0x2b203]

        $sequence_10 = { 488d8c24f0020000 e8???????? 90 418bd5 488d8c2470040000 }
            // n = 5, score = 100
            //   488d8c24f0020000     | dec                 eax
            //   e8????????           |                     
            //   90                   | arpl                ax, cx
            //   418bd5               | dec                 eax
            //   488d8c2470040000     | mov                 eax, dword ptr [ebx + 8]

        $sequence_11 = { 488d4c2450 e8???????? 498bcc e8???????? 4c8b642468 }
            // n = 5, score = 100
            //   488d4c2450           | dec                 eax
            //   e8????????           |                     
            //   498bcc               | lea                 ecx, [esp + 0x50]
            //   e8????????           |                     
            //   4c8b642468           | dec                 ecx

        $sequence_12 = { eb0f 49394e10 720b bb02000000 895c2420 }
            // n = 5, score = 100
            //   eb0f                 | inc                 ecx
            //   49394e10             | movzx               ebx, ch
            //   720b                 | dec                 esp
            //   bb02000000           | mov                 edi, dword ptr [ebp - 0x10]
            //   895c2420             | dec                 ecx

        $sequence_13 = { 440f45e8 410fb6dd 4c8b7df0 498bcf ff15???????? eb0d }
            // n = 6, score = 100
            //   440f45e8             | mov                 ecx, esp
            //   410fb6dd             | dec                 esp
            //   4c8b7df0             | mov                 esp, dword ptr [esp + 0x68]
            //   498bcf               | inc                 esp
            //   ff15????????         |                     
            //   eb0d                 | cmovne              ebp, eax

        $sequence_14 = { 488d0503b20200 488bd9 488901 f6c201 740a }
            // n = 5, score = 100
            //   488d0503b20200       | mov                 ecx, edi
            //   488bd9               | jmp                 0x16
            //   488901               | jmp                 0x11
            //   f6c201               | dec                 ecx
            //   740a                 | cmp                 dword ptr [esi + 0x10], ecx

        $sequence_15 = { 4c8d0510e00100 488d15c9a40100 e8???????? 488bd8 }
            // n = 4, score = 100
            //   4c8d0510e00100       | dec                 eax
            //   488d15c9a40100       | mov                 dword ptr [eax + edx*8 + 8], ecx
            //   e8????????           |                     
            //   488bd8               | dec                 eax

    condition:
        7 of them and filesize < 720896
}