rule win_getmail_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.getmail."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.getmail"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89442428 eb07 8d4c241c 51 }
            // n = 4, score = 100
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   eb07                 | jmp                 9
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   51                   | push                ecx

        $sequence_1 = { f3a4 8b442410 395840 7463 8b704c 8b7848 a1???????? }
            // n = 7, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   395840               | cmp                 dword ptr [eax + 0x40], ebx
            //   7463                 | je                  0x65
            //   8b704c               | mov                 esi, dword ptr [eax + 0x4c]
            //   8b7848               | mov                 edi, dword ptr [eax + 0x48]
            //   a1????????           |                     

        $sequence_2 = { e8???????? 83c40c 85c0 752d bf???????? 83c9ff f2ae }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   752d                 | jne                 0x2f
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_3 = { 56 e8???????? 83c40c 895c2430 85c0 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   895c2430             | mov                 dword ptr [esp + 0x30], ebx
            //   85c0                 | test                eax, eax

        $sequence_4 = { 7cf1 56 8bf1 c1e603 3b9618444100 }
            // n = 5, score = 100
            //   7cf1                 | jl                  0xfffffff3
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   c1e603               | shl                 esi, 3
            //   3b9618444100         | cmp                 edx, dword ptr [esi + 0x414418]

        $sequence_5 = { 895c244c 895c2450 8b84243c020000 8d54247c 52 53 8b08 }
            // n = 7, score = 100
            //   895c244c             | mov                 dword ptr [esp + 0x4c], ebx
            //   895c2450             | mov                 dword ptr [esp + 0x50], ebx
            //   8b84243c020000       | mov                 eax, dword ptr [esp + 0x23c]
            //   8d54247c             | lea                 edx, [esp + 0x7c]
            //   52                   | push                edx
            //   53                   | push                ebx
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_6 = { 8bfe 8bcb 33c0 f2ae f7d1 49 51 }
            // n = 7, score = 100
            //   8bfe                 | mov                 edi, esi
            //   8bcb                 | mov                 ecx, ebx
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   51                   | push                ecx

        $sequence_7 = { 8b4d00 68???????? 51 e8???????? 83c408 85c0 }
            // n = 6, score = 100
            //   8b4d00               | mov                 ecx, dword ptr [ebp]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8b442420 3bc3 741d 8d48ff 8a40ff 84c0 }
            // n = 6, score = 100
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   3bc3                 | cmp                 eax, ebx
            //   741d                 | je                  0x1f
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   8a40ff               | mov                 al, byte ptr [eax - 1]
            //   84c0                 | test                al, al

        $sequence_9 = { 8d542418 89442408 8b442410 56 52 8b08 }
            // n = 6, score = 100
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   56                   | push                esi
            //   52                   | push                edx
            //   8b08                 | mov                 ecx, dword ptr [eax]

    condition:
        7 of them and filesize < 188416
}