rule win_ghole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ghole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghole"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 89c7 e8???????? c745cc00000000 c745b800000000 eb14 c78540ffffffe9030000 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   89c7                 | mov                 edi, eax
            //   e8????????           |                     
            //   c745cc00000000       | mov                 dword ptr [ebp - 0x34], 0
            //   c745b800000000       | mov                 dword ptr [ebp - 0x48], 0
            //   eb14                 | jmp                 0x16
            //   c78540ffffffe9030000     | mov    dword ptr [ebp - 0xc0], 0x3e9

        $sequence_1 = { 8878e0 49 8be9 45 8be0 44 8bea }
            // n = 7, score = 100
            //   8878e0               | mov                 byte ptr [eax - 0x20], bh
            //   49                   | dec                 ecx
            //   8be9                 | mov                 ebp, ecx
            //   45                   | inc                 ebp
            //   8be0                 | mov                 esp, eax
            //   44                   | inc                 esp
            //   8bea                 | mov                 ebp, edx

        $sequence_2 = { 89f8 f7d0 89d9 21c1 48 8b45d0 48 }
            // n = 7, score = 100
            //   89f8                 | mov                 eax, edi
            //   f7d0                 | not                 eax
            //   89d9                 | mov                 ecx, ebx
            //   21c1                 | and                 ecx, eax
            //   48                   | dec                 eax
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   48                   | dec                 eax

        $sequence_3 = { 83ec30 48 897dd8 48 8975d0 48 8b45d0 }
            // n = 7, score = 100
            //   83ec30               | sub                 esp, 0x30
            //   48                   | dec                 eax
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi
            //   48                   | dec                 eax
            //   8975d0               | mov                 dword ptr [ebp - 0x30], esi
            //   48                   | dec                 eax
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]

        $sequence_4 = { 7509 83bdecf6ffffff 7448 8b855cffffff 80cc01 89855cffffff }
            // n = 6, score = 100
            //   7509                 | jne                 0xb
            //   83bdecf6ffffff       | cmp                 dword ptr [ebp - 0x914], -1
            //   7448                 | je                  0x4a
            //   8b855cffffff         | mov                 eax, dword ptr [ebp - 0xa4]
            //   80cc01               | or                  ah, 1
            //   89855cffffff         | mov                 dword ptr [ebp - 0xa4], eax

        $sequence_5 = { 48 8b4040 48 8945f0 48 8b45f0 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8b4040               | mov                 eax, dword ptr [eax + 0x40]
            //   48                   | dec                 eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   48                   | dec                 eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   48                   | dec                 eax

        $sequence_6 = { 8b5010 8b45f8 0345fc 89c0 48 01c2 48 }
            // n = 7, score = 100
            //   8b5010               | mov                 edx, dword ptr [eax + 0x10]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   89c0                 | mov                 eax, eax
            //   48                   | dec                 eax
            //   01c2                 | add                 edx, eax
            //   48                   | dec                 eax

        $sequence_7 = { 8b4008 8b55e4 48 8b4de8 48 89ce 48 }
            // n = 7, score = 100
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   48                   | dec                 eax
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   48                   | dec                 eax
            //   89ce                 | mov                 esi, ecx
            //   48                   | dec                 eax

        $sequence_8 = { 48 89c7 e8???????? 85c0 7515 8b55f8 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   89c7                 | mov                 edi, eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7515                 | jne                 0x17
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   48                   | dec                 eax

        $sequence_9 = { 48 8b1d???????? 48 8b55a0 48 8b45c0 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8b1d????????         |                     
            //   48                   | dec                 eax
            //   8b55a0               | mov                 edx, dword ptr [ebp - 0x60]
            //   48                   | dec                 eax
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]
            //   48                   | dec                 eax

    condition:
        7 of them and filesize < 622592
}