rule win_gibberish_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gibberish."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gibberish"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894dec 8975e8 668907 894dfc 8bce c745f001000000 8d5102 }
            // n = 7, score = 100
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi
            //   668907               | mov                 word ptr [edi], ax
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8bce                 | mov                 ecx, esi
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   8d5102               | lea                 edx, [ecx + 2]

        $sequence_1 = { 8b74242c 8bd0 8944245c 8bce 8bc6 c1c90b c1c007 }
            // n = 7, score = 100
            //   8b74242c             | mov                 esi, dword ptr [esp + 0x2c]
            //   8bd0                 | mov                 edx, eax
            //   8944245c             | mov                 dword ptr [esp + 0x5c], eax
            //   8bce                 | mov                 ecx, esi
            //   8bc6                 | mov                 eax, esi
            //   c1c90b               | ror                 ecx, 0xb
            //   c1c007               | rol                 eax, 7

        $sequence_2 = { 68???????? ff15???????? 85c0 7424 56 56 8d85fcfffdff }
            // n = 7, score = 100
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7424                 | je                  0x26
            //   56                   | push                esi
            //   56                   | push                esi
            //   8d85fcfffdff         | lea                 eax, [ebp - 0x20004]

        $sequence_3 = { 8b0ccdf2a94700 0fb680c8a94500 330cc5f1a94700 8bc2 c1e818 0fb680c8a94500 330cc5f4a94700 }
            // n = 7, score = 100
            //   8b0ccdf2a94700       | mov                 ecx, dword ptr [ecx*8 + 0x47a9f2]
            //   0fb680c8a94500       | movzx               eax, byte ptr [eax + 0x45a9c8]
            //   330cc5f1a94700       | xor                 ecx, dword ptr [eax*8 + 0x47a9f1]
            //   8bc2                 | mov                 eax, edx
            //   c1e818               | shr                 eax, 0x18
            //   0fb680c8a94500       | movzx               eax, byte ptr [eax + 0x45a9c8]
            //   330cc5f4a94700       | xor                 ecx, dword ptr [eax*8 + 0x47a9f4]

        $sequence_4 = { 330a 85d2 894b04 8d4a04 0f44ca }
            // n = 5, score = 100
            //   330a                 | xor                 ecx, dword ptr [edx]
            //   85d2                 | test                edx, edx
            //   894b04               | mov                 dword ptr [ebx + 4], ecx
            //   8d4a04               | lea                 ecx, [edx + 4]
            //   0f44ca               | cmove               ecx, edx

        $sequence_5 = { ffd3 8b45d8 8d3446 33c0 83c602 663906 75c3 }
            // n = 7, score = 100
            //   ffd3                 | call                ebx
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8d3446               | lea                 esi, [esi + eax*2]
            //   33c0                 | xor                 eax, eax
            //   83c602               | add                 esi, 2
            //   663906               | cmp                 word ptr [esi], ax
            //   75c3                 | jne                 0xffffffc5

        $sequence_6 = { f30f7e05???????? 0f114c2420 0f284c2450 660f3840c8 0f10442420 0f11542470 }
            // n = 6, score = 100
            //   f30f7e05????????     |                     
            //   0f114c2420           | movups              xmmword ptr [esp + 0x20], xmm1
            //   0f284c2450           | movaps              xmm1, xmmword ptr [esp + 0x50]
            //   660f3840c8           | pmulld              xmm1, xmm0
            //   0f10442420           | movups              xmm0, xmmword ptr [esp + 0x20]
            //   0f11542470           | movups              xmmword ptr [esp + 0x70], xmm2

        $sequence_7 = { 7535 017524 297528 2bd6 8b5c242c 5f }
            // n = 6, score = 100
            //   7535                 | jne                 0x37
            //   017524               | add                 dword ptr [ebp + 0x24], esi
            //   297528               | sub                 dword ptr [ebp + 0x28], esi
            //   2bd6                 | sub                 edx, esi
            //   8b5c242c             | mov                 ebx, dword ptr [esp + 0x2c]
            //   5f                   | pop                 edi

        $sequence_8 = { 6af5 eb03 50 6af6 ff15???????? 8b04bd80b64700 }
            // n = 6, score = 100
            //   6af5                 | push                -0xb
            //   eb03                 | jmp                 5
            //   50                   | push                eax
            //   6af6                 | push                -0xa
            //   ff15????????         |                     
            //   8b04bd80b64700       | mov                 eax, dword ptr [edi*4 + 0x47b680]

        $sequence_9 = { 33c8 8b44241c 33c6 23442414 33c6 03c8 8b442474 }
            // n = 7, score = 100
            //   33c8                 | xor                 ecx, eax
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   33c6                 | xor                 eax, esi
            //   23442414             | and                 eax, dword ptr [esp + 0x14]
            //   33c6                 | xor                 eax, esi
            //   03c8                 | add                 ecx, eax
            //   8b442474             | mov                 eax, dword ptr [esp + 0x74]

    condition:
        7 of them and filesize < 1068032
}