rule win_glasses_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.glasses."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.glasses"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b4d10 51 68???????? 8bce e8???????? 8d4de4 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]

        $sequence_1 = { e9???????? 8d8d38fdffff e9???????? 8d8d94feffff e9???????? 8d8dacfdffff e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8d38fdffff         | lea                 ecx, [ebp - 0x2c8]
            //   e9????????           |                     
            //   8d8d94feffff         | lea                 ecx, [ebp - 0x16c]
            //   e9????????           |                     
            //   8d8dacfdffff         | lea                 ecx, [ebp - 0x254]
            //   e9????????           |                     

        $sequence_2 = { ffd0 e9???????? 389d4afbffff 0f842f070000 8d8d10fbffff 889d4bfbffff e8???????? }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   e9????????           |                     
            //   389d4afbffff         | cmp                 byte ptr [ebp - 0x4b6], bl
            //   0f842f070000         | je                  0x735
            //   8d8d10fbffff         | lea                 ecx, [ebp - 0x4f0]
            //   889d4bfbffff         | mov                 byte ptr [ebp - 0x4b5], bl
            //   e8????????           |                     

        $sequence_3 = { eb05 1bc9 83d9ff 85c9 0f84643d0000 b9???????? 8d9b00000000 }
            // n = 7, score = 100
            //   eb05                 | jmp                 7
            //   1bc9                 | sbb                 ecx, ecx
            //   83d9ff               | sbb                 ecx, -1
            //   85c9                 | test                ecx, ecx
            //   0f84643d0000         | je                  0x3d6a
            //   b9????????           |                     
            //   8d9b00000000         | lea                 ebx, [ebx]

        $sequence_4 = { eb2d 8b5520 8b451c 8d8e00090000 51 8b4d18 52 }
            // n = 7, score = 100
            //   eb2d                 | jmp                 0x2f
            //   8b5520               | mov                 edx, dword ptr [ebp + 0x20]
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   8d8e00090000         | lea                 ecx, [esi + 0x900]
            //   51                   | push                ecx
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   52                   | push                edx

        $sequence_5 = { e8???????? 8ac3 e9???????? 68???????? e9???????? 8b16 8b4214 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8ac3                 | mov                 al, bl
            //   e9????????           |                     
            //   68????????           |                     
            //   e9????????           |                     
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]

        $sequence_6 = { f3ab 8b5510 52 e8???????? 83c404 5f 5e }
            // n = 7, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { e9???????? 8d8df4feffff e9???????? 8d8d08ffffff e9???????? 8b542408 8d420c }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8df4feffff         | lea                 ecx, [ebp - 0x10c]
            //   e9????????           |                     
            //   8d8d08ffffff         | lea                 ecx, [ebp - 0xf8]
            //   e9????????           |                     
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d420c               | lea                 eax, [edx + 0xc]

        $sequence_8 = { e8???????? 8d8d40fdffff 51 bb05000000 56 8d4d94 885dfc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8d40fdffff         | lea                 ecx, [ebp - 0x2c0]
            //   51                   | push                ecx
            //   bb05000000           | mov                 ebx, 5
            //   56                   | push                esi
            //   8d4d94               | lea                 ecx, [ebp - 0x6c]
            //   885dfc               | mov                 byte ptr [ebp - 4], bl

        $sequence_9 = { ff15???????? 399d60fcffff 8b854cfcffff 7306 8d854cfcffff 50 e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   399d60fcffff         | cmp                 dword ptr [ebp - 0x3a0], ebx
            //   8b854cfcffff         | mov                 eax, dword ptr [ebp - 0x3b4]
            //   7306                 | jae                 8
            //   8d854cfcffff         | lea                 eax, [ebp - 0x3b4]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 4177920
}