rule win_glassrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.glassrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.glassrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 32c0 5d 83c408 c21400 53 56 8d4524 }
            // n = 7, score = 200
            //   32c0                 | xor                 al, al
            //   5d                   | pop                 ebp
            //   83c408               | add                 esp, 8
            //   c21400               | ret                 0x14
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8d4524               | lea                 eax, [ebp + 0x24]

        $sequence_1 = { 895904 894108 89790c 8b4a04 e8???????? }
            // n = 5, score = 200
            //   895904               | mov                 dword ptr [ecx + 4], ebx
            //   894108               | mov                 dword ptr [ecx + 8], eax
            //   89790c               | mov                 dword ptr [ecx + 0xc], edi
            //   8b4a04               | mov                 ecx, dword ptr [edx + 4]
            //   e8????????           |                     

        $sequence_2 = { 0f8598000000 bf02000000 ff15???????? 6a00 8b95c4feffff }
            // n = 5, score = 200
            //   0f8598000000         | jne                 0x9e
            //   bf02000000           | mov                 edi, 2
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   8b95c4feffff         | mov                 edx, dword ptr [ebp - 0x13c]

        $sequence_3 = { 6860ea0000 ff15???????? 8d8c242c010000 c784243c020000ffffffff e8???????? 46 83fe05 }
            // n = 7, score = 200
            //   6860ea0000           | push                0xea60
            //   ff15????????         |                     
            //   8d8c242c010000       | lea                 ecx, [esp + 0x12c]
            //   c784243c020000ffffffff     | mov    dword ptr [esp + 0x23c], 0xffffffff
            //   e8????????           |                     
            //   46                   | inc                 esi
            //   83fe05               | cmp                 esi, 5

        $sequence_4 = { 8d5004 8945ec 8930 b941000000 33c0 8bfa }
            // n = 6, score = 200
            //   8d5004               | lea                 edx, [eax + 4]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8930                 | mov                 dword ptr [eax], esi
            //   b941000000           | mov                 ecx, 0x41
            //   33c0                 | xor                 eax, eax
            //   8bfa                 | mov                 edi, edx

        $sequence_5 = { 8d9578feffff 53 53 6a02 }
            // n = 4, score = 200
            //   8d9578feffff         | lea                 edx, [ebp - 0x188]
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a02                 | push                2

        $sequence_6 = { c7857cffffff44000000 c745a801010000 668975ac 895db8 895dbc }
            // n = 5, score = 200
            //   c7857cffffff44000000     | mov    dword ptr [ebp - 0x84], 0x44
            //   c745a801010000       | mov                 dword ptr [ebp - 0x58], 0x101
            //   668975ac             | mov                 word ptr [ebp - 0x54], si
            //   895db8               | mov                 dword ptr [ebp - 0x48], ebx
            //   895dbc               | mov                 dword ptr [ebp - 0x44], ebx

        $sequence_7 = { 8dbd85feffff 8945e0 8945e4 889d84feffff f3ab 66ab }
            // n = 6, score = 200
            //   8dbd85feffff         | lea                 edi, [ebp - 0x17b]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   889d84feffff         | mov                 byte ptr [ebp - 0x17c], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_8 = { 33ed 68905f0100 ff15???????? 6a00 }
            // n = 4, score = 200
            //   33ed                 | xor                 ebp, ebp
            //   68905f0100           | push                0x15f90
            //   ff15????????         |                     
            //   6a00                 | push                0

        $sequence_9 = { e8???????? 53 55 56 33c0 8bf1 89442410 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   33c0                 | xor                 eax, eax
            //   8bf1                 | mov                 esi, ecx
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

    condition:
        7 of them and filesize < 81920
}