rule win_go_red_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.go_red."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.go_red"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 84c0 740a 488b7c2470 e9???????? 488b7c2470 488b5748 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | dec                 esp
            //   740a                 | mov                 dword ptr [esp + 0xc0], esp
            //   488b7c2470           | dec                 ebp
            //   e9????????           |                     
            //   488b7c2470           | mov                 ebp, edx
            //   488b5748             | inc                 ebp

        $sequence_1 = { eb0a 488b7c2450 e8???????? 488b542470 4c8b442468 4c8b4c2438 488b5228 }
            // n = 7, score = 100
            //   eb0a                 | dec                 eax
            //   488b7c2450           | mov                 ecx, edx
            //   e8????????           |                     
            //   488b542470           | dec                 esp
            //   4c8b442468           | mov                 ecx, eax
            //   4c8b4c2438           | nop                 dword ptr [eax]
            //   488b5228             | dec                 esp

        $sequence_2 = { e8???????? 488b6d00 488d0526777d00 4889cb 0f1f00 e8???????? 4889442470 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b6d00             | dec                 eax
            //   488d0526777d00       | mov                 dword ptr [esp + 0xb8], ebx
            //   4889cb               | dec                 eax
            //   0f1f00               | mov                 eax, ecx
            //   e8????????           |                     
            //   4889442470           | dec                 ecx

        $sequence_3 = { e8???????? 48c7400802000000 48c7401002000000 833d????????00 750d 488b8c24c02f0000 488908 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48c7400802000000     | dec                 eax
            //   48c7401002000000     | mov                 edx, dword ptr [esp + 0x58]
            //   833d????????00       |                     
            //   750d                 | dec                 eax
            //   488b8c24c02f0000     | mov                 dword ptr [edx + 0x30], ecx
            //   488908               | dec                 esp

        $sequence_4 = { eb11 4889c7 488b8c24001c0000 90 e8???????? 488d0554889f00 e8???????? }
            // n = 7, score = 100
            //   eb11                 | dec                 esp
            //   4889c7               | mov                 eax, ecx
            //   488b8c24001c0000     | dec                 eax
            //   90                   | mov                 ebx, edi
            //   e8????????           |                     
            //   488d0554889f00       | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { e8???????? 488b942498000000 488bb424b0000000 4989c1 b901000000 41b801000000 488b442458 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b942498000000     | dec                 eax
            //   488bb424b0000000     | mov                 eax, dword ptr [esp + 0x50]
            //   4989c1               | dec                 eax
            //   b901000000           | mov                 ecx, dword ptr [esp + 0x28]
            //   41b801000000         | dec                 eax
            //   488b442458           | mov                 ebx, dword ptr [esp + 0x38]

        $sequence_6 = { e8???????? 4c89d8 e8???????? 4889f8 4c89d9 e8???????? 4c89c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c89d8               | lea                 edi, [eax + 0x28]
            //   e8????????           |                     
            //   4889f8               | dec                 esp
            //   4c89d9               | mov                 eax, dword ptr [esp + 0x70]
            //   e8????????           |                     
            //   4c89c0               | dec                 esp

        $sequence_7 = { eb1c 488d7802 4839f9 7c18 4839c1 0f86a8020000 0fb63c02 }
            // n = 7, score = 100
            //   eb1c                 | dec                 eax
            //   488d7802             | mov                 ebx, edx
            //   4839f9               | dec                 eax
            //   7c18                 | test                edi, edi
            //   4839c1               | dec                 esp
            //   0f86a8020000         | mov                 ecx, edx
            //   0fb63c02             | mov                 edi, 1

        $sequence_8 = { e8???????? 488d05da7f9e00 e8???????? 4889842458060000 48b9211f0000b9030000 488908 488b9c24481a0000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d05da7f9e00       | sbb                 ecx, ecx
            //   e8????????           |                     
            //   4889842458060000     | inc                 ecx
            //   48b9211f0000b9030000     | mov    ecx, 0
            //   488908               | dec                 ecx
            //   488b9c24481a0000     | sbb                 ecx, 0

        $sequence_9 = { e8???????? 488d0521e7a701 bb14000000 e8???????? 90 4889442408 895c2410 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d0521e7a701       | adc                 ebx, edi
            //   bb14000000           | dec                 ebp
            //   e8????????           |                     
            //   90                   | adc                 ecx, ebp
            //   4889442408           | dec                 esp
            //   895c2410             | mov                 dword ptr [esp + 0x628], ecx

    condition:
        7 of them and filesize < 85566464
}