rule win_goldbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.goldbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.goldbackdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bc8 7444 8b8564fdffff 83f810 720d 40 50 }
            // n = 7, score = 100
            //   3bc8                 | cmp                 ecx, eax
            //   7444                 | je                  0x46
            //   8b8564fdffff         | mov                 eax, dword ptr [ebp - 0x29c]
            //   83f810               | cmp                 eax, 0x10
            //   720d                 | jb                  0xf
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_1 = { e8???????? 83ee01 7437 83ee01 7413 83ee01 7556 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83ee01               | sub                 esi, 1
            //   7437                 | je                  0x39
            //   83ee01               | sub                 esi, 1
            //   7413                 | je                  0x15
            //   83ee01               | sub                 esi, 1
            //   7556                 | jne                 0x58

        $sequence_2 = { 0fb6c0 81e7fdff0000 c1e908 83cf02 8b0482 33c1 8b8ef0000100 }
            // n = 7, score = 100
            //   0fb6c0               | movzx               eax, al
            //   81e7fdff0000         | and                 edi, 0xfffd
            //   c1e908               | shr                 ecx, 8
            //   83cf02               | or                  edi, 2
            //   8b0482               | mov                 eax, dword ptr [edx + eax*4]
            //   33c1                 | xor                 eax, ecx
            //   8b8ef0000100         | mov                 ecx, dword ptr [esi + 0x100f0]

        $sequence_3 = { 8b4c2430 53 55 56 8b19 57 f6c318 }
            // n = 7, score = 100
            //   8b4c2430             | mov                 ecx, dword ptr [esp + 0x30]
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8b19                 | mov                 ebx, dword ptr [ecx]
            //   57                   | push                edi
            //   f6c318               | test                bl, 0x18

        $sequence_4 = { 68???????? 8d4de4 e8???????? 8b75e4 8bc7 838db8fbffff04 8bce }
            // n = 7, score = 100
            //   68????????           |                     
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   8b75e4               | mov                 esi, dword ptr [ebp - 0x1c]
            //   8bc7                 | mov                 eax, edi
            //   838db8fbffff04       | or                  dword ptr [ebp - 0x448], 4
            //   8bce                 | mov                 ecx, esi

        $sequence_5 = { 84c0 75f9 2bce 51 52 eb07 6a00 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   2bce                 | sub                 ecx, esi
            //   51                   | push                ecx
            //   52                   | push                edx
            //   eb07                 | jmp                 9
            //   6a00                 | push                0

        $sequence_6 = { 750a 68b4040000 e9???????? 8b470c 55 53 83600cf0 }
            // n = 7, score = 100
            //   750a                 | jne                 0xc
            //   68b4040000           | push                0x4b4
            //   e9????????           |                     
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   55                   | push                ebp
            //   53                   | push                ebx
            //   83600cf0             | and                 dword ptr [eax + 0xc], 0xfffffff0

        $sequence_7 = { 6bc830 8b049540bd5100 c644012889 8b049540bd5100 885c0129 8b049540bd5100 8064012dfe }
            // n = 7, score = 100
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b049540bd5100       | mov                 eax, dword ptr [edx*4 + 0x51bd40]
            //   c644012889           | mov                 byte ptr [ecx + eax + 0x28], 0x89
            //   8b049540bd5100       | mov                 eax, dword ptr [edx*4 + 0x51bd40]
            //   885c0129             | mov                 byte ptr [ecx + eax + 0x29], bl
            //   8b049540bd5100       | mov                 eax, dword ptr [edx*4 + 0x51bd40]
            //   8064012dfe           | and                 byte ptr [ecx + eax + 0x2d], 0xfe

        $sequence_8 = { 8d85a4fdffff 8d8d34fdffff 0f4385a4fdffff 50 e8???????? 83bda0fdffff10 8d858cfdffff }
            // n = 7, score = 100
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   8d8d34fdffff         | lea                 ecx, [ebp - 0x2cc]
            //   0f4385a4fdffff       | cmovae              eax, dword ptr [ebp - 0x25c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83bda0fdffff10       | cmp                 dword ptr [ebp - 0x260], 0x10
            //   8d858cfdffff         | lea                 eax, [ebp - 0x274]

        $sequence_9 = { ff7514 51 80780d00 8bcb 0f856effffff 8b7508 57 }
            // n = 7, score = 100
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   51                   | push                ecx
            //   80780d00             | cmp                 byte ptr [eax + 0xd], 0
            //   8bcb                 | mov                 ecx, ebx
            //   0f856effffff         | jne                 0xffffff74
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi

    condition:
        7 of them and filesize < 2455552
}