rule win_goldenspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.goldenspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.goldenspy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b0cbd48b24700 c644112900 837dfc00 7507 }
            // n = 4, score = 100
            //   8b0cbd48b24700       | mov                 ecx, dword ptr [edi*4 + 0x47b248]
            //   c644112900           | mov                 byte ptr [ecx + edx + 0x29], 0
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7507                 | jne                 9

        $sequence_1 = { 8bce ff5010 eb2d 8b06 8bce ff501c eb24 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   eb2d                 | jmp                 0x2f
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bce                 | mov                 ecx, esi
            //   ff501c               | call                dword ptr [eax + 0x1c]
            //   eb24                 | jmp                 0x26

        $sequence_2 = { 8bc8 e8???????? 8d4de0 c645fc0c e8???????? }
            // n = 5, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   c645fc0c             | mov                 byte ptr [ebp - 4], 0xc
            //   e8????????           |                     

        $sequence_3 = { ff75bc 8bcf e8???????? 3bf3 0f85b4feffff b001 }
            // n = 6, score = 100
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   3bf3                 | cmp                 esi, ebx
            //   0f85b4feffff         | jne                 0xfffffeba
            //   b001                 | mov                 al, 1

        $sequence_4 = { 50 8bcb e8???????? ba01000000 eb0d }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   ba01000000           | mov                 edx, 1
            //   eb0d                 | jmp                 0xf

        $sequence_5 = { e8???????? 84c0 0f84d7000000 8b55c8 8d4dd8 e8???????? c745fc01000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f84d7000000         | je                  0xdd
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1

        $sequence_6 = { 50 8bce c78588fdffff00000000 e8???????? 8b00 3b06 7507 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   c78588fdffff00000000     | mov    dword ptr [ebp - 0x278], 0
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   3b06                 | cmp                 eax, dword ptr [esi]
            //   7507                 | jne                 9

        $sequence_7 = { 51 0f434520 50 51 8d8dccfeffff e8???????? 837d1c10 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   0f434520             | cmovae              eax, dword ptr [ebp + 0x20]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8dccfeffff         | lea                 ecx, [ebp - 0x134]
            //   e8????????           |                     
            //   837d1c10             | cmp                 dword ptr [ebp + 0x1c], 0x10

        $sequence_8 = { 8b08 2bd1 52 eb2b 8b8538ffffff a804 752d }
            // n = 7, score = 100
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   2bd1                 | sub                 edx, ecx
            //   52                   | push                edx
            //   eb2b                 | jmp                 0x2d
            //   8b8538ffffff         | mov                 eax, dword ptr [ebp - 0xc8]
            //   a804                 | test                al, 4
            //   752d                 | jne                 0x2f

        $sequence_9 = { 6a00 50 6802000080 ff15???????? 85c0 7557 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   6802000080           | push                0x80000002
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7557                 | jne                 0x59

    condition:
        7 of them and filesize < 1081344
}