rule win_gootkit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gootkit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gootkit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41 3bca 72f2 56 6a00 ff15???????? }
            // n = 6, score = 1700
            //   41                   | inc                 ecx
            //   3bca                 | cmp                 ecx, edx
            //   72f2                 | jb                  0xfffffff4
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_1 = { 3bca 72f2 335df0 6a10 58 }
            // n = 5, score = 1700
            //   3bca                 | cmp                 ecx, edx
            //   72f2                 | jb                  0xfffffff4
            //   335df0               | xor                 ebx, dword ptr [ebp - 0x10]
            //   6a10                 | push                0x10
            //   58                   | pop                 eax

        $sequence_2 = { 33c0 85c9 0f444508 5d c20400 }
            // n = 5, score = 1700
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   0f444508             | cmove               eax, dword ptr [ebp + 8]
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4

        $sequence_3 = { 50 56 ff15???????? 56 ffd7 8bd0 33ff }
            // n = 7, score = 1700
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8bd0                 | mov                 edx, eax
            //   33ff                 | xor                 edi, edi

        $sequence_4 = { 59 85c0 740c 8b30 33ff 0375dc }
            // n = 6, score = 1700
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   33ff                 | xor                 edi, edi
            //   0375dc               | add                 esi, dword ptr [ebp - 0x24]

        $sequence_5 = { 8b840888000000 eb04 8b440878 03c1 c3 }
            // n = 5, score = 1700
            //   8b840888000000       | mov                 eax, dword ptr [eax + ecx + 0x88]
            //   eb04                 | jmp                 6
            //   8b440878             | mov                 eax, dword ptr [eax + ecx + 0x78]
            //   03c1                 | add                 eax, ecx
            //   c3                   | ret                 

        $sequence_6 = { e8???????? 8b5dfc ff75f4 6a00 ff15???????? }
            // n = 5, score = 1700
            //   e8????????           |                     
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_7 = { 894df4 50 ff75fc ffd7 85c0 744b }
            // n = 6, score = 1700
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   744b                 | je                  0x4d

        $sequence_8 = { f3aa 68???????? ff15???????? 50 }
            // n = 4, score = 1200
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   68????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_9 = { 8b7df4 32c0 8b4de4 f3aa }
            // n = 4, score = 1200
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   32c0                 | xor                 al, al
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   f3aa                 | rep stosb           byte ptr es:[edi], al

        $sequence_10 = { 50 68???????? ff15???????? 85c0 7505 e8???????? }
            // n = 6, score = 1100
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   e8????????           |                     

        $sequence_11 = { 50 e8???????? 83c40c 68fd000000 }
            // n = 4, score = 1100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68fd000000           | push                0xfd

        $sequence_12 = { 50 8b4508 8b00 99 }
            // n = 4, score = 1000
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   99                   | cdq                 

        $sequence_13 = { c705????????01000000 c705????????02000000 8be5 5d }
            // n = 4, score = 900
            //   c705????????01000000     |     
            //   c705????????02000000     |     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_14 = { 833d????????00 750a 6a32 ff15???????? }
            // n = 4, score = 800
            //   833d????????00       |                     
            //   750a                 | jne                 0xc
            //   6a32                 | push                0x32
            //   ff15????????         |                     

        $sequence_15 = { e8???????? 6a0c 6a08 ff15???????? 50 ff15???????? }
            // n = 6, score = 800
            //   e8????????           |                     
            //   6a0c                 | push                0xc
            //   6a08                 | push                8
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_16 = { 6808020000 6a00 ff15???????? 50 }
            // n = 4, score = 800
            //   6808020000           | push                0x208
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_17 = { 6a02 ff15???????? 6888130000 ff15???????? }
            // n = 4, score = 700
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   6888130000           | push                0x1388
            //   ff15????????         |                     

        $sequence_18 = { e8???????? 8d45fc 50 6a01 6a01 6a00 6800000002 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6800000002           | push                0x2000000

        $sequence_19 = { e8???????? 85c0 750c c705????????03000000 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   c705????????03000000     |     

        $sequence_20 = { 8b4508 8b00 99 52 50 6a00 }
            // n = 6, score = 400
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   99                   | cdq                 
            //   52                   | push                edx
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_21 = { 53 53 53 8901 }
            // n = 4, score = 300
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_22 = { 0f114f20 0f104840 0f114730 0f104050 0f114f40 0f104860 0f114750 }
            // n = 7, score = 200
            //   0f114f20             | movups              xmmword ptr [edi + 0x20], xmm1
            //   0f104840             | movups              xmm1, xmmword ptr [eax + 0x40]
            //   0f114730             | movups              xmmword ptr [edi + 0x30], xmm0
            //   0f104050             | movups              xmm0, xmmword ptr [eax + 0x50]
            //   0f114f40             | movups              xmmword ptr [edi + 0x40], xmm1
            //   0f104860             | movups              xmm1, xmmword ptr [eax + 0x60]
            //   0f114750             | movups              xmmword ptr [edi + 0x50], xmm0

        $sequence_23 = { 754c 8b5e02 8d45e4 6a1c 50 }
            // n = 5, score = 200
            //   754c                 | jne                 0x4e
            //   8b5e02               | mov                 ebx, dword ptr [esi + 2]
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   6a1c                 | push                0x1c
            //   50                   | push                eax

        $sequence_24 = { 03c1 3bd8 7323 8b33 }
            // n = 4, score = 200
            //   03c1                 | add                 eax, ecx
            //   3bd8                 | cmp                 ebx, eax
            //   7323                 | jae                 0x25
            //   8b33                 | mov                 esi, dword ptr [ebx]

        $sequence_25 = { 85c0 56 0f45ca 894dfc ff15???????? }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   56                   | push                esi
            //   0f45ca               | cmovne              ecx, edx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   ff15????????         |                     

        $sequence_26 = { 8b4c2434 ff15???????? 0fb74c2432 ff15???????? }
            // n = 4, score = 200
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   ff15????????         |                     
            //   0fb74c2432           | movzx               ecx, word ptr [esp + 0x32]
            //   ff15????????         |                     

        $sequence_27 = { 0f104010 0f110f 0f104820 0f114710 0f104030 0f114f20 0f104840 }
            // n = 7, score = 200
            //   0f104010             | movups              xmm0, xmmword ptr [eax + 0x10]
            //   0f110f               | movups              xmmword ptr [edi], xmm1
            //   0f104820             | movups              xmm1, xmmword ptr [eax + 0x20]
            //   0f114710             | movups              xmmword ptr [edi + 0x10], xmm0
            //   0f104030             | movups              xmm0, xmmword ptr [eax + 0x30]
            //   0f114f20             | movups              xmmword ptr [edi + 0x20], xmm1
            //   0f104840             | movups              xmm1, xmmword ptr [eax + 0x40]

        $sequence_28 = { 8b4070 894770 be01000000 ff15???????? }
            // n = 4, score = 200
            //   8b4070               | mov                 eax, dword ptr [eax + 0x70]
            //   894770               | mov                 dword ptr [edi + 0x70], eax
            //   be01000000           | mov                 esi, 1
            //   ff15????????         |                     

        $sequence_29 = { 0f104060 0f114760 8b4070 894770 }
            // n = 4, score = 200
            //   0f104060             | movups              xmm0, xmmword ptr [eax + 0x60]
            //   0f114760             | movups              xmmword ptr [edi + 0x60], xmm0
            //   8b4070               | mov                 eax, dword ptr [eax + 0x70]
            //   894770               | mov                 dword ptr [edi + 0x70], eax

        $sequence_30 = { 7510 8d4864 ff15???????? ffc3 83fb0a }
            // n = 5, score = 200
            //   7510                 | jne                 0x12
            //   8d4864               | lea                 ecx, [eax + 0x64]
            //   ff15????????         |                     
            //   ffc3                 | inc                 ebx
            //   83fb0a               | cmp                 ebx, 0xa

        $sequence_31 = { c602e9 2bc8 894a01 83c205 8b4610 33c9 }
            // n = 6, score = 200
            //   c602e9               | mov                 byte ptr [edx], 0xe9
            //   2bc8                 | sub                 ecx, eax
            //   894a01               | mov                 dword ptr [edx + 1], ecx
            //   83c205               | add                 edx, 5
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   33c9                 | xor                 ecx, ecx

        $sequence_32 = { 0f104860 0f114750 0f114f60 b801000000 }
            // n = 4, score = 200
            //   0f104860             | movups              xmm1, xmmword ptr [eax + 0x60]
            //   0f114750             | movups              xmmword ptr [edi + 0x50], xmm0
            //   0f114f60             | movups              xmmword ptr [edi + 0x60], xmm1
            //   b801000000           | mov                 eax, 1

        $sequence_33 = { 8b4de8 b84d5a0000 663901 754e 8b513c 03d1 813a50450000 }
            // n = 7, score = 200
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   b84d5a0000           | mov                 eax, 0x5a4d
            //   663901               | cmp                 word ptr [ecx], ax
            //   754e                 | jne                 0x50
            //   8b513c               | mov                 edx, dword ptr [ecx + 0x3c]
            //   03d1                 | add                 edx, ecx
            //   813a50450000         | cmp                 dword ptr [edx], 0x4550

        $sequence_34 = { ffc3 83fb0a 7cd5 33c0 }
            // n = 4, score = 200
            //   ffc3                 | inc                 ebx
            //   83fb0a               | cmp                 ebx, 0xa
            //   7cd5                 | jl                  0xffffffd7
            //   33c0                 | xor                 eax, eax

        $sequence_35 = { ffd3 8b8de4fdffff 8b36 85f6 75a2 8b3f 85ff }
            // n = 7, score = 200
            //   ffd3                 | call                ebx
            //   8b8de4fdffff         | mov                 ecx, dword ptr [ebp - 0x21c]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   85f6                 | test                esi, esi
            //   75a2                 | jne                 0xffffffa4
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   85ff                 | test                edi, edi

        $sequence_36 = { 8b7df4 85ff 7414 57 8bce e8???????? }
            // n = 6, score = 200
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   85ff                 | test                edi, edi
            //   7414                 | je                  0x16
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 516096
}