rule win_gophe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gophe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gophe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 833902 0f94c0 84c0 7407 }
            // n = 4, score = 300
            //   833902               | cmp                 dword ptr [ecx], 2
            //   0f94c0               | sete                al
            //   84c0                 | test                al, al
            //   7407                 | je                  9

        $sequence_1 = { b905000000 ff15???????? 8b05???????? 85c0 }
            // n = 4, score = 200
            //   b905000000           | dec                 eax
            //   ff15????????         |                     
            //   8b05????????         |                     
            //   85c0                 | mov                 edi, eax

        $sequence_2 = { 8d45f4 64a300000000 68e0000000 e8???????? 83c404 }
            // n = 5, score = 200
            //   8d45f4               | mov                 dword ptr [ebp - 4], 2
            //   64a300000000         | mov                 edi, eax
            //   68e0000000           | add                 esp, 8
            //   e8????????           |                     
            //   83c404               | lea                 edx, [eax + 1]

        $sequence_3 = { 85c0 7509 b803000000 5d }
            // n = 4, score = 200
            //   85c0                 | push                0xe0
            //   7509                 | add                 esp, 4
            //   b803000000           | mov                 dword ptr [ebp - 0x10], eax
            //   5d                   | mov                 esi, eax

        $sequence_4 = { c744242880000008 c744242003000000 4533c9 ba00000080 458d4103 }
            // n = 5, score = 200
            //   c744242880000008     | dec                 eax
            //   c744242003000000     | mov                 ecx, dword ptr [esp + 0x40]
            //   4533c9               | mov                 edi, eax
            //   ba00000080           | test                eax, eax
            //   458d4103             | js                  0x25

        $sequence_5 = { 85f6 7416 6830020000 6a00 }
            // n = 4, score = 200
            //   85f6                 | sete                al
            //   7416                 | test                al, al
            //   6830020000           | je                  0xb
            //   6a00                 | jmp                 0xb

        $sequence_6 = { c744242010000000 4533c9 4c8b4210 8b5208 ff9088000000 }
            // n = 5, score = 200
            //   c744242010000000     | mov                 dword ptr [esp + 0x20], 0x10
            //   4533c9               | inc                 ebp
            //   4c8b4210             | xor                 ecx, ecx
            //   8b5208               | dec                 esp
            //   ff9088000000         | mov                 eax, dword ptr [edx + 0x10]

        $sequence_7 = { 57 68???????? c70605000000 e8???????? }
            // n = 4, score = 200
            //   57                   | push                0x230
            //   68????????           |                     
            //   c70605000000         | push                0
            //   e8????????           |                     

        $sequence_8 = { 85c0 7838 488b4c2440 ff15???????? 8bf8 85c0 }
            // n = 6, score = 200
            //   85c0                 | inc                 ebp
            //   7838                 | xor                 ecx, ecx
            //   488b4c2440           | inc                 ebp
            //   ff15????????         |                     
            //   8bf8                 | xor                 eax, eax
            //   85c0                 | mov                 edx, 0x80000000

        $sequence_9 = { 8bf0 83c404 8bd6 b9???????? }
            // n = 4, score = 200
            //   8bf0                 | je                  0x1a
            //   83c404               | push                0x230
            //   8bd6                 | push                0
            //   b9????????           |                     

        $sequence_10 = { 8bf8 e8???????? 83c408 8d5001 }
            // n = 4, score = 200
            //   8bf8                 | test                al, al
            //   e8????????           |                     
            //   83c408               | je                  0xb
            //   8d5001               | cmp                 dword ptr [ecx], 2

        $sequence_11 = { 837d0800 7507 b802000000 5d c3 33c0 }
            // n = 6, score = 200
            //   837d0800             | lea                 eax, [ebp - 0xc]
            //   7507                 | mov                 dword ptr fs:[0], eax
            //   b802000000           | push                0xe0
            //   5d                   | add                 esp, 4
            //   c3                   | lea                 eax, [ebp - 0xc]
            //   33c0                 | mov                 dword ptr fs:[0], eax

        $sequence_12 = { 90 4c8b45b8 4d8bc8 4d8b00 }
            // n = 4, score = 200
            //   90                   | mov                 dword ptr [esp + 0x20], 3
            //   4c8b45b8             | inc                 ebp
            //   4d8bc8               | xor                 ecx, ecx
            //   4d8b00               | mov                 edx, 0x80000000

        $sequence_13 = { b801000000 eb09 83c8ff eb04 }
            // n = 4, score = 200
            //   b801000000           | mov                 ecx, 5
            //   eb09                 | test                eax, eax
            //   83c8ff               | test                eax, eax
            //   eb04                 | js                  0x3a

        $sequence_14 = { c744242880000000 c744242003000000 4533c9 4533c0 ba00000080 ff15???????? 488bf8 }
            // n = 7, score = 200
            //   c744242880000000     | mov                 eax, dword ptr [edx + 0x10]
            //   c744242003000000     | mov                 edx, dword ptr [edx + 8]
            //   4533c9               | call                dword ptr [eax + 0x88]
            //   4533c0               | test                eax, eax
            //   ba00000080           | mov                 dword ptr [esp + 0x28], 0x80
            //   ff15????????         |                     
            //   488bf8               | mov                 dword ptr [esp + 0x20], 3

        $sequence_15 = { 8b4dec 33cd e8???????? 8be5 5d c21000 c745fc02000000 }
            // n = 7, score = 200
            //   8b4dec               | cmp                 dword ptr [ecx], 2
            //   33cd                 | sete                al
            //   e8????????           |                     
            //   8be5                 | test                al, al
            //   5d                   | je                  0xe
            //   c21000               | cmp                 dword ptr [ecx], 2
            //   c745fc02000000       | sete                al

    condition:
        7 of them and filesize < 1582080
}