rule win_gotohttp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gotohttp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gotohttp"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb46 41f6401001 7412 0fb64c2428 ba01000000 66d3e2 66412350f8 }
            // n = 7, score = 100
            //   eb46                 | inc                 ebp
            //   41f6401001           | mov                 esi, ecx
            //   7412                 | dec                 ecx
            //   0fb64c2428           | mov                 edi, eax
            //   ba01000000           | dec                 eax
            //   66d3e2               | mov                 ebp, edx
            //   66412350f8           | dec                 eax

        $sequence_1 = { f30f590d???????? f30f5905???????? f30f58cc f30f58c4 f30f59c8 730a f30f1005???????? }
            // n = 7, score = 100
            //   f30f590d????????     |                     
            //   f30f5905????????     |                     
            //   f30f58cc             | cmp                 eax, 0xe
            //   f30f58c4             | je                  0xfbe
            //   f30f59c8             | cmp                 eax, 0xf
            //   730a                 | je                  0xfbe
            //   f30f1005????????     |                     

        $sequence_2 = { eb05 ffc0 894334 488bcb e8???????? 488bcb 4c8bf8 }
            // n = 7, score = 100
            //   eb05                 | dec                 ebp
            //   ffc0                 | lea                 eax, [ecx + ecx]
            //   894334               | dec                 ecx
            //   488bcb               | mul                 edi
            //   e8????????           |                     
            //   488bcb               | jle                 0x1d71
            //   4c8bf8               | dec                 esp

        $sequence_3 = { 89442454 488bd3 33c9 ff15???????? 488b87e0030000 8b4860 8d0c8d01000000 }
            // n = 7, score = 100
            //   89442454             | je                  0x19d4
            //   488bd3               | inc                 ecx
            //   33c9                 | mov                 ah, 1
            //   ff15????????         |                     
            //   488b87e0030000       | jmp                 0x19d7
            //   8b4860               | dec                 esp
            //   8d0c8d01000000       | mov                 dword ptr [esp + 0x80], esp

        $sequence_4 = { e8???????? 488bf8 4885c0 7445 488d5010 488910 4863c5 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bf8               | dec                 eax
            //   4885c0               | mov                 ecx, edi
            //   7445                 | add                 eax, 8
            //   488d5010             | sub                 al, 4
            //   488910               | jne                 0x137f
            //   4863c5               | dec                 eax

        $sequence_5 = { 83fb02 0f85ee010000 4585ed 741d 448b4d5c 488b9590000000 488b4d40 }
            // n = 7, score = 100
            //   83fb02               | xor                 eax, eax
            //   0f85ee010000         | dec                 esp
            //   4585ed               | mov                 edi, eax
            //   741d                 | dec                 esp
            //   448b4d5c             | mov                 ebp, eax
            //   488b9590000000       | dec                 eax
            //   488b4d40             | mov                 dword ptr [esp + 0x40], eax

        $sequence_6 = { e9???????? b920000000 e8???????? 488bd8 4885c0 741a 48897008 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   b920000000           | dec                 ecx
            //   e8????????           |                     
            //   488bd8               | mov                 eax, dword ptr [ebx + 8]
            //   4885c0               | inc                 esp
            //   741a                 | mov                 eax, ebx
            //   48897008             | dec                 edx

        $sequence_7 = { ff5010 488d4b18 ff15???????? c7430800000000 40f6c601 7408 488bcb }
            // n = 7, score = 100
            //   ff5010               | inc                 esp
            //   488d4b18             | mov                 dword ptr [esp + 0x48], eax
            //   ff15????????         |                     
            //   c7430800000000       | mov                 dword ptr [esp + 0x68], eax
            //   40f6c601             | mov                 eax, dword ptr [esi + 0x4b0]
            //   7408                 | dec                 esp
            //   488bcb               | lea                 eax, [0x274ad5]

        $sequence_8 = { eba3 488b8c2480000000 4881c150050000 488b842480000000 48898888000000 488b8c2480000000 488b842480000000 }
            // n = 7, score = 100
            //   eba3                 | xor                 esp, esp
            //   488b8c2480000000     | jmp                 0xbfe
            //   4881c150050000       | inc                 ebp
            //   488b842480000000     | xor                 esp, esp
            //   48898888000000       | cmp                 ebx, 0x19000
            //   488b8c2480000000     | jl                  0xbae
            //   488b842480000000     | dec                 eax

        $sequence_9 = { eb17 41389efb020000 751f c64705c2 bb02000000 4885f6 7411 }
            // n = 7, score = 100
            //   eb17                 | jne                 0x62b
            //   41389efb020000       | xor                 al, al
            //   751f                 | dec                 eax
            //   c64705c2             | mov                 ebx, dword ptr [esp + 0x30]
            //   bb02000000           | dec                 eax
            //   4885f6               | add                 esp, 0x20
            //   7411                 | pop                 edi

    condition:
        7 of them and filesize < 6266704
}