rule win_govrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.govrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.govrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4dc4 e8???????? 8b00 50 8d4708 895f10 895f14 }
            // n = 7, score = 200
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   8d4708               | lea                 eax, [edi + 8]
            //   895f10               | mov                 dword ptr [edi + 0x10], ebx
            //   895f14               | mov                 dword ptr [edi + 0x14], ebx

        $sequence_1 = { 897804 8b7904 8930 8b31 0facfe01 d1ef 83780400 }
            // n = 7, score = 200
            //   897804               | mov                 dword ptr [eax + 4], edi
            //   8b7904               | mov                 edi, dword ptr [ecx + 4]
            //   8930                 | mov                 dword ptr [eax], esi
            //   8b31                 | mov                 esi, dword ptr [ecx]
            //   0facfe01             | shrd                esi, edi, 1
            //   d1ef                 | shr                 edi, 1
            //   83780400             | cmp                 dword ptr [eax + 4], 0

        $sequence_2 = { 59 03f1 8dbc24b8000000 33c0 f3a7 7418 }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   03f1                 | add                 esi, ecx
            //   8dbc24b8000000       | lea                 edi, [esp + 0xb8]
            //   33c0                 | xor                 eax, eax
            //   f3a7                 | repe cmpsd          dword ptr [esi], dword ptr es:[edi]
            //   7418                 | je                  0x1a

        $sequence_3 = { ff15???????? 83a65401000000 c3 53 55 56 8d6f44 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   83a65401000000       | and                 dword ptr [esi + 0x154], 0
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8d6f44               | lea                 ebp, [edi + 0x44]

        $sequence_4 = { ff15???????? 83a65401000000 c3 53 55 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   83a65401000000       | and                 dword ptr [esi + 0x154], 0
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   55                   | push                ebp

        $sequence_5 = { 6a00 6a00 ff15???????? 8b4c2404 8901 85c0 7404 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6

        $sequence_6 = { 832d????????04 e9???????? 55 8bec 83ec14 a1???????? 53 }
            // n = 7, score = 200
            //   832d????????04       |                     
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec14               | sub                 esp, 0x14
            //   a1????????           |                     
            //   53                   | push                ebx

        $sequence_7 = { 7543 837d1000 0f845cfeffff 8b87a8000000 2b442420 8b8fac000000 1b4c2424 }
            // n = 7, score = 200
            //   7543                 | jne                 0x45
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   0f845cfeffff         | je                  0xfffffe62
            //   8b87a8000000         | mov                 eax, dword ptr [edi + 0xa8]
            //   2b442420             | sub                 eax, dword ptr [esp + 0x20]
            //   8b8fac000000         | mov                 ecx, dword ptr [edi + 0xac]
            //   1b4c2424             | sbb                 ecx, dword ptr [esp + 0x24]

        $sequence_8 = { 8d4df8 8d4518 e8???????? 8b45f8 0b45fc 750a 2145fc }
            // n = 7, score = 200
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   8d4518               | lea                 eax, [ebp + 0x18]
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   0b45fc               | or                  eax, dword ptr [ebp - 4]
            //   750a                 | jne                 0xc
            //   2145fc               | and                 dword ptr [ebp - 4], eax

        $sequence_9 = { 8945f8 8b4508 ff700c ff15???????? 8bf0 }
            // n = 5, score = 200
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff700c               | push                dword ptr [eax + 0xc]
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

    condition:
        7 of them and filesize < 761856
}