rule win_gozi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gozi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gozi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4dd0 03d1 8915???????? 03d9 891d???????? a3???????? }
            // n = 6, score = 100
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   03d1                 | add                 edx, ecx
            //   8915????????         |                     
            //   03d9                 | add                 ebx, ecx
            //   891d????????         |                     
            //   a3????????           |                     

        $sequence_1 = { 6a00 68cee6ac00 52 50 e8???????? 898500ffffff }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   68cee6ac00           | push                0xace6ce
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   898500ffffff         | mov                 dword ptr [ebp - 0x100], eax

        $sequence_2 = { 50 ff7508 8d8771030000 ff10 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d8771030000         | lea                 eax, [edi + 0x371]
            //   ff10                 | call                dword ptr [eax]

        $sequence_3 = { fb 5c 3c32 7e02 19c1 a6 3327 }
            // n = 7, score = 100
            //   fb                   | sti                 
            //   5c                   | pop                 esp
            //   3c32                 | cmp                 al, 0x32
            //   7e02                 | jle                 4
            //   19c1                 | sbb                 ecx, eax
            //   a6                   | cmpsb               byte ptr [esi], byte ptr es:[edi]
            //   3327                 | xor                 esp, dword ptr [edi]

        $sequence_4 = { c9 50 0c73 0e 96 3b5375 60 }
            // n = 7, score = 100
            //   c9                   | leave               
            //   50                   | push                eax
            //   0c73                 | or                  al, 0x73
            //   0e                   | push                cs
            //   96                   | xchg                eax, esi
            //   3b5375               | cmp                 edx, dword ptr [ebx + 0x75]
            //   60                   | pushal              

        $sequence_5 = { 55 f79bfe7ca80d a7 ad b710 }
            // n = 5, score = 100
            //   55                   | push                ebp
            //   f79bfe7ca80d         | neg                 dword ptr [ebx + 0xda87cfe]
            //   a7                   | cmpsd               dword ptr [esi], dword ptr es:[edi]
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   b710                 | mov                 bh, 0x10

        $sequence_6 = { 6a00 e8???????? 85c0 0f8899000000 8b45a8 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8899000000         | js                  0x9f
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]

        $sequence_7 = { 8ee1 54 257c693a5c 48 fb 5c }
            // n = 6, score = 100
            //   8ee1                 | mov                 fs, ecx
            //   54                   | push                esp
            //   257c693a5c           | and                 eax, 0x5c3a697c
            //   48                   | dec                 eax
            //   fb                   | sti                 
            //   5c                   | pop                 esp

        $sequence_8 = { e8???????? 03f0 46 ebdc ff75fc e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   03f0                 | add                 esi, eax
            //   46                   | inc                 esi
            //   ebdc                 | jmp                 0xffffffde
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_9 = { 6a00 6a00 6a00 8d87a2020000 ff10 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d87a2020000         | lea                 eax, [edi + 0x2a2]
            //   ff10                 | call                dword ptr [eax]

        $sequence_10 = { 0f8459010000 50 ff7570 ff15???????? }
            // n = 4, score = 100
            //   0f8459010000         | je                  0x15f
            //   50                   | push                eax
            //   ff7570               | push                dword ptr [ebp + 0x70]
            //   ff15????????         |                     

        $sequence_11 = { 50 8b35???????? ffd6 57 68???????? e8???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   57                   | push                edi
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_12 = { 50 68???????? 6a00 e8???????? c745ec01000000 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   6a00                 | push                0
            //   e8????????           |                     
            //   c745ec01000000       | mov                 dword ptr [ebp - 0x14], 1

        $sequence_13 = { 8b4d18 e8???????? 8b45e0 50 }
            // n = 4, score = 100
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   e8????????           |                     
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   50                   | push                eax

        $sequence_14 = { 3327 72e7 3ebb4a68d947 d93e }
            // n = 4, score = 100
            //   3327                 | xor                 esp, dword ptr [edi]
            //   72e7                 | jb                  0xffffffe9
            //   3ebb4a68d947         | mov                 ebx, 0x47d9684a
            //   d93e                 | fnstcw              word ptr [esi]

        $sequence_15 = { 3818 0f8453feffff 50 e8???????? 89463c ffb574ffffff }
            // n = 6, score = 100
            //   3818                 | cmp                 byte ptr [eax], bl
            //   0f8453feffff         | je                  0xfffffe59
            //   50                   | push                eax
            //   e8????????           |                     
            //   89463c               | mov                 dword ptr [esi + 0x3c], eax
            //   ffb574ffffff         | push                dword ptr [ebp - 0x8c]

        $sequence_16 = { e8???????? ebda 8bc3 c1f805 8d3c85e00c4400 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   ebda                 | jmp                 0xffffffdc
            //   8bc3                 | mov                 eax, ebx
            //   c1f805               | sar                 eax, 5
            //   8d3c85e00c4400       | lea                 edi, [eax*4 + 0x440ce0]

        $sequence_17 = { 89950cfeffff 8b8d08feffff 0b8d0cfeffff 7431 0fc0f2 }
            // n = 5, score = 100
            //   89950cfeffff         | mov                 dword ptr [ebp - 0x1f4], edx
            //   8b8d08feffff         | mov                 ecx, dword ptr [ebp - 0x1f8]
            //   0b8d0cfeffff         | or                  ecx, dword ptr [ebp - 0x1f4]
            //   7431                 | je                  0x33
            //   0fc0f2               | xadd                dl, dh

        $sequence_18 = { f6c5ae 69d5e21d6c7f 0fc0f2 0fce 8af4 }
            // n = 5, score = 100
            //   f6c5ae               | test                ch, 0xae
            //   69d5e21d6c7f         | imul                edx, ebp, 0x7f6c1de2
            //   0fc0f2               | xadd                dl, dh
            //   0fce                 | bswap               esi
            //   8af4                 | mov                 dh, ah

        $sequence_19 = { ffb5acfeffff e8???????? 8bd8 039dacfeffff ff7510 53 }
            // n = 6, score = 100
            //   ffb5acfeffff         | push                dword ptr [ebp - 0x154]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   039dacfeffff         | add                 ebx, dword ptr [ebp - 0x154]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   53                   | push                ebx

        $sequence_20 = { dc6f1b 95 bf633629a8 02738f 1da2c9dde2 }
            // n = 5, score = 100
            //   dc6f1b               | fsubr               qword ptr [edi + 0x1b]
            //   95                   | xchg                eax, ebp
            //   bf633629a8           | mov                 edi, 0xa8293663
            //   02738f               | add                 dh, byte ptr [ebx - 0x71]
            //   1da2c9dde2           | sbb                 eax, 0xe2ddc9a2

        $sequence_21 = { 84e5 0fce 0fbef4 69f116814003 0faceaca c0d6f6 }
            // n = 6, score = 100
            //   84e5                 | test                ch, ah
            //   0fce                 | bswap               esi
            //   0fbef4               | movsx               esi, ah
            //   69f116814003         | imul                esi, ecx, 0x3408116
            //   0faceaca             | shrd                edx, ebp, 0xca
            //   c0d6f6               | rcl                 dh, 0xf6

        $sequence_22 = { 8b440704 8945a4 50 e8???????? 8b4648 8b7c0708 897da0 }
            // n = 7, score = 100
            //   8b440704             | mov                 eax, dword ptr [edi + eax + 4]
            //   8945a4               | mov                 dword ptr [ebp - 0x5c], eax
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4648               | mov                 eax, dword ptr [esi + 0x48]
            //   8b7c0708             | mov                 edi, dword ptr [edi + eax + 8]
            //   897da0               | mov                 dword ptr [ebp - 0x60], edi

        $sequence_23 = { 68???????? ffb5bcfdffff ff15???????? 897dfc e8???????? 8d85c0fdffff 50 }
            // n = 7, score = 100
            //   68????????           |                     
            //   ffb5bcfdffff         | push                dword ptr [ebp - 0x244]
            //   ff15????????         |                     
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   e8????????           |                     
            //   8d85c0fdffff         | lea                 eax, [ebp - 0x240]
            //   50                   | push                eax

        $sequence_24 = { 03c7 03cf 83ff1f 0f87a4030000 ff24bd95244300 }
            // n = 5, score = 100
            //   03c7                 | add                 eax, edi
            //   03cf                 | add                 ecx, edi
            //   83ff1f               | cmp                 edi, 0x1f
            //   0f87a4030000         | ja                  0x3aa
            //   ff24bd95244300       | jmp                 dword ptr [edi*4 + 0x432495]

        $sequence_25 = { e8???????? 83f8ff 7442 8985fcfeffff 68???????? e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7442                 | je                  0x44
            //   8985fcfeffff         | mov                 dword ptr [ebp - 0x104], eax
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_26 = { 8ad0 4a 8ad0 84c1 }
            // n = 4, score = 100
            //   8ad0                 | mov                 dl, al
            //   4a                   | dec                 edx
            //   8ad0                 | mov                 dl, al
            //   84c1                 | test                cl, al

        $sequence_27 = { 6af4 dbe9 68912b4384 2383e08985e4 0572b6e2f4 fd }
            // n = 6, score = 100
            //   6af4                 | push                -0xc
            //   dbe9                 | fucomi              st(1)
            //   68912b4384           | push                0x84432b91
            //   2383e08985e4         | and                 eax, dword ptr [ebx - 0x1b7a7620]
            //   0572b6e2f4           | add                 eax, 0xf4e2b672
            //   fd                   | std                 

        $sequence_28 = { 128b42926614 12a502b346d1 41 b87e8da638 e022 }
            // n = 5, score = 100
            //   128b42926614         | adc                 cl, byte ptr [ebx + 0x14669242]
            //   12a502b346d1         | adc                 ah, byte ptr [ebp - 0x2eb94cfe]
            //   41                   | inc                 ecx
            //   b87e8da638           | mov                 eax, 0x38a68d7e
            //   e022                 | loopne              0x24

        $sequence_29 = { 68???????? ff75c0 ff15???????? 834dfcff e8???????? ff7508 8d45c4 }
            // n = 7, score = 100
            //   68????????           |                     
            //   ff75c0               | push                dword ptr [ebp - 0x40]
            //   ff15????????         |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d45c4               | lea                 eax, [ebp - 0x3c]

        $sequence_30 = { 0f848ffbffff 50 8b4658 8d443804 50 e8???????? 898574ffffff }
            // n = 7, score = 100
            //   0f848ffbffff         | je                  0xfffffb95
            //   50                   | push                eax
            //   8b4658               | mov                 eax, dword ptr [esi + 0x58]
            //   8d443804             | lea                 eax, [eax + edi + 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   898574ffffff         | mov                 dword ptr [ebp - 0x8c], eax

        $sequence_31 = { 5b 5f c9 c21400 8d87eb040000 8b00 }
            // n = 6, score = 100
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   c9                   | leave               
            //   c21400               | ret                 0x14
            //   8d87eb040000         | lea                 eax, [edi + 0x4eb]
            //   8b00                 | mov                 eax, dword ptr [eax]

    condition:
        7 of them and filesize < 568320
}