rule win_gpcode_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gpcode."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gpcode"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a1???????? a3???????? 6800001000 68???????? ff35???????? }
            // n = 5, score = 1400
            //   a1????????           |                     
            //   a3????????           |                     
            //   6800001000           | push                0x100000
            //   68????????           |                     
            //   ff35????????         |                     

        $sequence_1 = { 68???????? e8???????? 91 6a00 }
            // n = 4, score = 1400
            //   68????????           |                     
            //   e8????????           |                     
            //   91                   | xchg                eax, ecx
            //   6a00                 | push                0

        $sequence_2 = { e8???????? e8???????? c705????????01000000 c3 55 8bec }
            // n = 6, score = 1400
            //   e8????????           |                     
            //   e8????????           |                     
            //   c705????????01000000     |     
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_3 = { 68f4010000 e8???????? 833d????????01 75ed e8???????? }
            // n = 5, score = 1200
            //   68f4010000           | push                0x1f4
            //   e8????????           |                     
            //   833d????????01       |                     
            //   75ed                 | jne                 0xffffffef
            //   e8????????           |                     

        $sequence_4 = { 0f840d020000 a3???????? 68???????? ff35???????? e8???????? 85c0 }
            // n = 6, score = 1100
            //   0f840d020000         | je                  0x213
            //   a3????????           |                     
            //   68????????           |                     
            //   ff35????????         |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_5 = { a1???????? eb18 8b1d???????? 53 }
            // n = 4, score = 1100
            //   a1????????           |                     
            //   eb18                 | jmp                 0x1a
            //   8b1d????????         |                     
            //   53                   | push                ebx

        $sequence_6 = { ff7508 6aff 68???????? ff75f4 ff15???????? }
            // n = 5, score = 1100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6aff                 | push                -1
            //   68????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     

        $sequence_7 = { e8???????? 85c0 0f8447020000 a3???????? 68???????? }
            // n = 5, score = 1100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8447020000         | je                  0x24d
            //   a3????????           |                     
            //   68????????           |                     

        $sequence_8 = { 23d8 741f 80c141 880d???????? }
            // n = 4, score = 800
            //   23d8                 | and                 ebx, eax
            //   741f                 | je                  0x21
            //   80c141               | add                 cl, 0x41
            //   880d????????         |                     

        $sequence_9 = { e8???????? 6a0a 68???????? 6a00 e8???????? 0bc0 7504 }
            // n = 7, score = 800
            //   e8????????           |                     
            //   6a0a                 | push                0xa
            //   68????????           |                     
            //   6a00                 | push                0
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax
            //   7504                 | jne                 6

        $sequence_10 = { 75dc 85c9 7415 85c0 }
            // n = 4, score = 100
            //   75dc                 | jne                 0xffffffde
            //   85c9                 | test                ecx, ecx
            //   7415                 | je                  0x17
            //   85c0                 | test                eax, eax

        $sequence_11 = { a0???????? 2c30 a2???????? eb0a }
            // n = 4, score = 100
            //   a0????????           |                     
            //   2c30                 | sub                 al, 0x30
            //   a2????????           |                     
            //   eb0a                 | jmp                 0xc

        $sequence_12 = { 53 ff7508 56 50 6802010000 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   56                   | push                esi
            //   50                   | push                eax
            //   6802010000           | push                0x102

        $sequence_13 = { e9???????? ff75f4 6a08 ff35???????? ff15???????? }
            // n = 5, score = 100
            //   e9????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6a08                 | push                8
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_14 = { 47 46 8a06 84c0 8975f4 }
            // n = 5, score = 100
            //   47                   | inc                 edi
            //   46                   | inc                 esi
            //   8a06                 | mov                 al, byte ptr [esi]
            //   84c0                 | test                al, al
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi

        $sequence_15 = { 8bfb 2b7df4 837decff 8955bc 8955c4 }
            // n = 5, score = 100
            //   8bfb                 | mov                 edi, ebx
            //   2b7df4               | sub                 edi, dword ptr [ebp - 0xc]
            //   837decff             | cmp                 dword ptr [ebp - 0x14], -1
            //   8955bc               | mov                 dword ptr [ebp - 0x44], edx
            //   8955c4               | mov                 dword ptr [ebp - 0x3c], edx

        $sequence_16 = { 50 57 ff15???????? 8d45e4 50 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax

        $sequence_17 = { 740c 803f29 7507 c6020f }
            // n = 4, score = 100
            //   740c                 | je                  0xe
            //   803f29               | cmp                 byte ptr [edi], 0x29
            //   7507                 | jne                 9
            //   c6020f               | mov                 byte ptr [edx], 0xf

    condition:
        7 of them and filesize < 761856
}