rule win_graftor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.graftor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.graftor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 393d???????? 7523 8d85fcbfffff 50 57 57 6a29 }
            // n = 7, score = 100
            //   393d????????         |                     
            //   7523                 | jne                 0x25
            //   8d85fcbfffff         | lea                 eax, [ebp - 0x4004]
            //   50                   | push                eax
            //   57                   | push                edi
            //   57                   | push                edi
            //   6a29                 | push                0x29

        $sequence_1 = { 57 e8???????? 85c0 743f 8365fc00 8d45fc 50 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   743f                 | je                  0x41
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_2 = { c3 53 8b5e14 57 8bf8 3bdf 771d }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   8b5e14               | mov                 ebx, dword ptr [esi + 0x14]
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   3bdf                 | cmp                 ebx, edi
            //   771d                 | ja                  0x1f

        $sequence_3 = { 5e 5d c20400 6a50 b8b69f4c00 e8???????? 8b7d10 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   6a50                 | push                0x50
            //   b8b69f4c00           | mov                 eax, 0x4c9fb6
            //   e8????????           |                     
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]

        $sequence_4 = { e8???????? 6800aa4d00 8db5ecbeffff c645fc04 e8???????? 8b8d58bfffff 33ff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6800aa4d00           | push                0x4daa00
            //   8db5ecbeffff         | lea                 esi, [ebp - 0x4114]
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   e8????????           |                     
            //   8b8d58bfffff         | mov                 ecx, dword ptr [ebp - 0x40a8]
            //   33ff                 | xor                 edi, edi

        $sequence_5 = { e8???????? 845df0 740b 6a00 53 8d4db8 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   845df0               | test                byte ptr [ebp - 0x10], bl
            //   740b                 | je                  0xd
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e8????????           |                     

        $sequence_6 = { 741c 50 ff15???????? 85c0 7511 8b4604 3d58b74e00 }
            // n = 7, score = 100
            //   741c                 | je                  0x1e
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7511                 | jne                 0x13
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   3d58b74e00           | cmp                 eax, 0x4eb758

        $sequence_7 = { c68424a8030000fc 8d84244c020000 8bf4 89a424c4000000 50 e8???????? c68424a8030000fa }
            // n = 7, score = 100
            //   c68424a8030000fc     | mov                 byte ptr [esp + 0x3a8], 0xfc
            //   8d84244c020000       | lea                 eax, [esp + 0x24c]
            //   8bf4                 | mov                 esi, esp
            //   89a424c4000000       | mov                 dword ptr [esp + 0xc4], esp
            //   50                   | push                eax
            //   e8????????           |                     
            //   c68424a8030000fa     | mov                 byte ptr [esp + 0x3a8], 0xfa

        $sequence_8 = { e8???????? 83c418 84c0 747f 66d16dc8 0fb745c8 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   84c0                 | test                al, al
            //   747f                 | je                  0x81
            //   66d16dc8             | shr                 word ptr [ebp - 0x38], 1
            //   0fb745c8             | movzx               eax, word ptr [ebp - 0x38]

        $sequence_9 = { 897dac e8???????? 660fbe00 6a05 8d53bf 59 }
            // n = 6, score = 100
            //   897dac               | mov                 dword ptr [ebp - 0x54], edi
            //   e8????????           |                     
            //   660fbe00             | movsx               ax, byte ptr [eax]
            //   6a05                 | push                5
            //   8d53bf               | lea                 edx, [ebx - 0x41]
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 294912
}