rule win_graphdrop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.graphdrop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.graphdrop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4155 0f77 53 90 }
            // n = 4, score = 300
            //   4155                 | mov                 edx, 1
            //   0f77                 | mov                 dword ptr [ebp - 0x34], eax
            //   53                   | xor                 ecx, ecx
            //   90                   | mov                 edx, 4

        $sequence_1 = { 4155 49c7c501000000 4150 4152 415a 4158 }
            // n = 6, score = 300
            //   4155                 | dec                 eax
            //   49c7c501000000       | lea                 ecx, [ebp + 0x108]
            //   4150                 | mov                 byte ptr [ebp + 0x5f7], 1
            //   4152                 | dec                 eax
            //   415a                 | mov                 edx, dword ptr [ebp + 0x200]
            //   4158                 | dec                 eax

        $sequence_2 = { 0f77 4157 90 415f }
            // n = 4, score = 300
            //   0f77                 | je                  0x120a
            //   4157                 | psrlq               mm5, 0x19
            //   90                   | emms                
            //   415f                 | inc                 ecx

        $sequence_3 = { 0f77 0f77 415d 90 }
            // n = 4, score = 300
            //   0f77                 | inc                 ecx
            //   0f77                 | push                ebx
            //   415d                 | pslld               mm5, 0x18
            //   90                   | pop                 eax

        $sequence_4 = { 50 58 5a 49ffc9 }
            // n = 4, score = 300
            //   50                   | dec                 esp
            //   58                   | add                 eax, eax
            //   5a                   | xor                 edx, ecx
            //   49ffc9               | mov                 dword ptr [eax], edx

        $sequence_5 = { 0f77 0f77 5b 0f77 }
            // n = 4, score = 300
            //   0f77                 | inc                 ecx
            //   0f77                 | push                edx
            //   5b                   | pcmpgtb             mm2, mm3
            //   0f77                 | pslld               mm5, 0x56

        $sequence_6 = { 90 0f77 415c e9???????? }
            // n = 4, score = 300
            //   90                   | lea                 eax, [eax + edx*8 + 0x18]
            //   0f77                 | dec                 eax
            //   415c                 | mov                 dword ptr [ebp + 0x38], eax
            //   e9????????           |                     

        $sequence_7 = { 49c7c501000000 4150 4152 415a }
            // n = 4, score = 300
            //   49c7c501000000       | jmp                 0x457
            //   4150                 | movzx               eax, word ptr [eax + ebx*2]
            //   4152                 | and                 eax, 0x117
            //   415a                 | dec                 eax

        $sequence_8 = { 4150 4152 415a 4158 }
            // n = 4, score = 300
            //   4150                 | jmp                 0x11c1
            //   4152                 | inc                 ecx
            //   415a                 | push                edx
            //   4158                 | paddsw              mm3, mm1

        $sequence_9 = { 0f77 4155 0f77 4150 }
            // n = 4, score = 300
            //   0f77                 | dec                 ecx
            //   4155                 | rol                 edx, 0x14
            //   0f77                 | inc                 cx
            //   4150                 | ror                 edx, 5

    condition:
        7 of them and filesize < 4186112
}