rule win_graphical_neutrino_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.graphical_neutrino."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.graphical_neutrino"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 56 53 498b18 458b5808 }
            // n = 5, score = 500
            //   57                   | dec                 eax
            //   56                   | lea                 ecx, [0x3e4f2]
            //   53                   | dec                 eax
            //   498b18               | lea                 ecx, [0x3f802]
            //   458b5808             | dec                 eax

        $sequence_1 = { e8???????? 4c89e1 4c89f2 4c8d4010 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   4c89e1               | dec                 eax
            //   4c89f2               | lea                 ecx, [0x5d46]
            //   4c8d4010             | jne                 0x1462

        $sequence_2 = { 8b6c242c 48637c2428 8d743d00 39f7 7f2b 83fe0f }
            // n = 6, score = 500
            //   8b6c242c             | lea                 ecx, [0xffffec33]
            //   48637c2428           | je                  0x183c
            //   8d743d00             | dec                 ecx
            //   39f7                 | mov                 eax, 0x5a711eb8
            //   7f2b                 | insd                dword ptr es:[edi], dx
            //   83fe0f               | sub                 al, 0xe4

        $sequence_3 = { 83c030 83c230 8806 488d4602 885601 }
            // n = 5, score = 500
            //   83c030               | lea                 eax, [0x3c38c]
            //   83c230               | dec                 eax
            //   8806                 | mov                 edx, edi
            //   488d4602             | dec                 eax
            //   885601               | lea                 ecx, [0x3dc9d]

        $sequence_4 = { 488d8424d8020000 4c8dbc24c8020000 48898424c8020000 488d442460 }
            // n = 4, score = 500
            //   488d8424d8020000     | test                eax, eax
            //   4c8dbc24c8020000     | je                  0x199
            //   48898424c8020000     | dec                 eax
            //   488d442460           | lea                 ecx, [0x40366]

        $sequence_5 = { 488b742470 4c8b7c2450 8a05???????? 84c0 }
            // n = 4, score = 500
            //   488b742470           | ret                 
            //   4c8b7c2450           | dec                 eax
            //   8a05????????         |                     
            //   84c0                 | lea                 ecx, [0x42295]

        $sequence_6 = { 7518 488b5108 48c1e004 480302 }
            // n = 4, score = 500
            //   7518                 | dec                 eax
            //   488b5108             | lea                 edi, [esp + 0x30]
            //   48c1e004             | dec                 eax
            //   480302               | mov                 eax, dword ptr [esp + 0x50]

        $sequence_7 = { 4863ee 4d89e0 488d4c2b02 e8???????? 488d5302 b030 89f1 }
            // n = 7, score = 500
            //   4863ee               | mov                 edx, 1
            //   4d89e0               | dec                 esp
            //   488d4c2b02           | mov                 ebp, esp
            //   e8????????           |                     
            //   488d5302             | dec                 esp
            //   b030                 | mov                 esi, dword ptr [ebx]
            //   89f1                 | dec                 esp

        $sequence_8 = { 4c8b4c2438 eb26 4584f6 750e 488b17 428a1422 88541d5a }
            // n = 7, score = 500
            //   4c8b4c2438           | lea                 eax, [0xffffa326]
            //   eb26                 | dec                 eax
            //   4584f6               | lea                 edx, [0x626f]
            //   750e                 | dec                 esp
            //   488b17               | mov                 ecx, esp
            //   428a1422             | dec                 ecx
            //   88541d5a             | mov                 ebp, eax

        $sequence_9 = { 4885d2 0f840d020000 8a02 ffc8 3c01 0f8701020000 }
            // n = 6, score = 500
            //   4885d2               | test                eax, eax
            //   0f840d020000         | je                  0x94d
            //   8a02                 | xor                 eax, eax
            //   ffc8                 | dec                 eax
            //   3c01                 | lea                 edx, [0x4132e]
            //   0f8701020000         | test                eax, eax

    condition:
        7 of them and filesize < 674816
}