rule win_graphican_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.graphican."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.graphican"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bbed0030000 8b5dfc 2bf8 8d04fa 8b51fc 8b7de8 899486e8010000 }
            // n = 7, score = 200
            //   8bbed0030000         | mov                 edi, dword ptr [esi + 0x3d0]
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   2bf8                 | sub                 edi, eax
            //   8d04fa               | lea                 eax, [edx + edi*8]
            //   8b51fc               | mov                 edx, dword ptr [ecx - 4]
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   899486e8010000       | mov                 dword ptr [esi + eax*4 + 0x1e8], edx

        $sequence_1 = { 757b 8b4d0c 57 8b7d08 8955fc 894d08 85c0 }
            // n = 7, score = 200
            //   757b                 | jne                 0x7d
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   85c0                 | test                eax, eax

        $sequence_2 = { 57 c785f0dfffff00000000 ff15???????? 8b85ecdfffff 8b8df0dfffff 53 50 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   c785f0dfffff00000000     | mov    dword ptr [ebp - 0x2010], 0
            //   ff15????????         |                     
            //   8b85ecdfffff         | mov                 eax, dword ptr [ebp - 0x2014]
            //   8b8df0dfffff         | mov                 ecx, dword ptr [ebp - 0x2010]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_3 = { 8b7de8 899486e8010000 8b45ec 40 43 }
            // n = 5, score = 200
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   899486e8010000       | mov                 dword ptr [esi + eax*4 + 0x1e8], edx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   40                   | inc                 eax
            //   43                   | inc                 ebx

        $sequence_4 = { 897dc0 3c30 7c04 3c39 7e4b 8b5d08 397318 }
            // n = 7, score = 200
            //   897dc0               | mov                 dword ptr [ebp - 0x40], edi
            //   3c30                 | cmp                 al, 0x30
            //   7c04                 | jl                  6
            //   3c39                 | cmp                 al, 0x39
            //   7e4b                 | jle                 0x4d
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   397318               | cmp                 dword ptr [ebx + 0x18], esi

        $sequence_5 = { 746d 53 8d9ef4030000 807e0400 8bc3 7428 33d2 }
            // n = 7, score = 200
            //   746d                 | je                  0x6f
            //   53                   | push                ebx
            //   8d9ef4030000         | lea                 ebx, [esi + 0x3f4]
            //   807e0400             | cmp                 byte ptr [esi + 4], 0
            //   8bc3                 | mov                 eax, ebx
            //   7428                 | je                  0x2a
            //   33d2                 | xor                 edx, edx

        $sequence_6 = { 5e c3 33c0 33d2 85c0 5f 0f94c0 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx
            //   85c0                 | test                eax, eax
            //   5f                   | pop                 edi
            //   0f94c0               | sete                al

        $sequence_7 = { 8b4148 ffd0 8b7dc0 33f6 895dc8 895dc4 }
            // n = 6, score = 200
            //   8b4148               | mov                 eax, dword ptr [ecx + 0x48]
            //   ffd0                 | call                eax
            //   8b7dc0               | mov                 edi, dword ptr [ebp - 0x40]
            //   33f6                 | xor                 esi, esi
            //   895dc8               | mov                 dword ptr [ebp - 0x38], ebx
            //   895dc4               | mov                 dword ptr [ebp - 0x3c], ebx

        $sequence_8 = { 8b10 50 8b4208 ffd0 8b45c8 3bc3 }
            // n = 6, score = 200
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   50                   | push                eax
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   ffd0                 | call                eax
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   3bc3                 | cmp                 eax, ebx

        $sequence_9 = { 83c40c 50 e8???????? 8bf8 83c404 }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c404               | add                 esp, 4

    condition:
        7 of them and filesize < 362496
}