rule win_grateful_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grateful_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grateful_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7411 e8???????? e8???????? 33c0 e9???????? }
            // n = 5, score = 600
            //   7411                 | je                  0x13
            //   e8????????           |                     
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     

        $sequence_1 = { eb07 b8fcffffff eb02 33c0 }
            // n = 4, score = 600
            //   eb07                 | jmp                 9
            //   b8fcffffff           | mov                 eax, 0xfffffffc
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { e8???????? 99 b980ee3600 f7f9 }
            // n = 4, score = 600
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b980ee3600           | mov                 ecx, 0x36ee80
            //   f7f9                 | idiv                ecx

        $sequence_3 = { 83f801 7510 e8???????? e8???????? }
            // n = 4, score = 600
            //   83f801               | cmp                 eax, 1
            //   7510                 | jne                 0x12
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_4 = { 7407 b8f6ffffff eb02 33c0 }
            // n = 4, score = 600
            //   7407                 | je                  9
            //   b8f6ffffff           | mov                 eax, 0xfffffff6
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { b8feffffff eb1a b8fdffffff eb13 b8fcffffff }
            // n = 5, score = 600
            //   b8feffffff           | mov                 eax, 0xfffffffe
            //   eb1a                 | jmp                 0x1c
            //   b8fdffffff           | mov                 eax, 0xfffffffd
            //   eb13                 | jmp                 0x15
            //   b8fcffffff           | mov                 eax, 0xfffffffc

        $sequence_6 = { 0385d0fbffff 8985d0fbffff 6a18 6a00 8d4de4 51 e8???????? }
            // n = 7, score = 500
            //   0385d0fbffff         | push                eax
            //   8985d0fbffff         | push                0
            //   6a18                 | push                0x410
            //   6a00                 | add                 eax, dword ptr [ebp - 0x430]
            //   8d4de4               | mov                 dword ptr [ebp - 0x430], eax
            //   51                   | push                0x18
            //   e8????????           |                     

        $sequence_7 = { 0fb61401 52 b804000000 6bc000 }
            // n = 4, score = 500
            //   0fb61401             | movzx               edx, byte ptr [ecx + eax]
            //   52                   | push                edx
            //   b804000000           | mov                 eax, 4
            //   6bc000               | imul                eax, eax, 0

        $sequence_8 = { 83e80e 50 e8???????? 83c40c 85c0 7457 6a03 }
            // n = 7, score = 500
            //   83e80e               | dec                 eax
            //   50                   | lea                 ecx, [0x26091]
            //   e8????????           |                     
            //   83c40c               | movsx               eax, byte ptr [ecx + eax]
            //   85c0                 | sub                 eax, 0xe
            //   7457                 | push                eax
            //   6a03                 | add                 esp, 0xc

        $sequence_9 = { 894110 8b550c 8b420c c1e803 50 68ff000000 8b4dfc }
            // n = 7, score = 500
            //   894110               | jl                  0x67
            //   8b550c               | mov                 ecx, dword ptr [ebp - 0x20008]
            //   8b420c               | movzx               edx, byte ptr [ebp + ecx - 0x20002]
            //   c1e803               | mov                 dword ptr [ecx + 0x10], eax
            //   50                   | mov                 edx, dword ptr [ebp + 0xc]
            //   68ff000000           | mov                 eax, dword ptr [edx + 0xc]
            //   8b4dfc               | shr                 eax, 3

        $sequence_10 = { 0f8c8c000000 8b8df8fffdff 0fb6940dfafffdff 83fa3a }
            // n = 4, score = 500
            //   0f8c8c000000         | jl                  0x92
            //   8b8df8fffdff         | mov                 ecx, dword ptr [ebp - 0x20008]
            //   0fb6940dfafffdff     | movzx               edx, byte ptr [ebp + ecx - 0x20006]
            //   83fa3a               | cmp                 edx, 0x3a

        $sequence_11 = { 83bdd0fbffff00 7568 6a0f 8b85e0fbffff 83e80f }
            // n = 5, score = 500
            //   83bdd0fbffff00       | push                eax
            //   7568                 | push                0xff
            //   6a0f                 | mov                 ecx, dword ptr [ebp - 4]
            //   8b85e0fbffff         | cmp                 dword ptr [ebp - 0x430], 0
            //   83e80f               | jne                 0x6a

        $sequence_12 = { 83f830 7c62 8b8df8fffdff 0fb6940dfefffdff }
            // n = 4, score = 500
            //   83f830               | test                eax, eax
            //   7c62                 | je                  0x5e
            //   8b8df8fffdff         | push                3
            //   0fb6940dfefffdff     | cmp                 eax, 0x30

        $sequence_13 = { 8945fc c785f8fbffff00000000 c785e8fbffff00000000 8b4508 50 6a00 6810040000 }
            // n = 7, score = 500
            //   8945fc               | push                0xf
            //   c785f8fbffff00000000     | mov    eax, dword ptr [ebp - 0x420]
            //   c785e8fbffff00000000     | sub    eax, 0xf
            //   8b4508               | mov                 dword ptr [ebp - 4], eax
            //   50                   | mov                 dword ptr [ebp - 0x408], 0
            //   6a00                 | mov                 dword ptr [ebp - 0x418], 0
            //   6810040000           | mov                 eax, dword ptr [ebp + 8]

        $sequence_14 = { 0fbe0401 83f04d 88842486010000 b801000000 486bc037 }
            // n = 5, score = 200
            //   0fbe0401             | movsx               eax, byte ptr [ecx + eax]
            //   83f04d               | xor                 eax, 0x4d
            //   88842486010000       | mov                 byte ptr [esp + 0x186], al
            //   b801000000           | mov                 eax, 1
            //   486bc037             | dec                 eax

        $sequence_15 = { ff15???????? 837c246400 750a b801000000 e9???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   837c246400           | imul                eax, eax, 0x37
            //   750a                 | cmp                 dword ptr [esp + 0x64], 0
            //   b801000000           | jne                 0xc
            //   e9????????           |                     

    condition:
        7 of them and filesize < 3964928
}