rule win_grimplant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grimplant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grimplant"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb13 4889c3 4889f0 e8???????? 488b942480000000 84c0 742a }
            // n = 7, score = 100
            //   eb13                 | dec                 eax
            //   4889c3               | test                edx, edx
            //   4889f0               | jne                 0x7bc
            //   e8????????           |                     
            //   488b942480000000     | nop                 
            //   84c0                 | dec                 eax
            //   742a                 | lea                 edx, [0x28528f]

        $sequence_1 = { eb09 488d7908 e8???????? 488b6c2420 4883c428 c3 0f1f4000 }
            // n = 7, score = 100
            //   eb09                 | dec                 esp
            //   488d7908             | mov                 ecx, dword ptr [esp + 0x140]
            //   e8????????           |                     
            //   488b6c2420           | dec                 eax
            //   4883c428             | mov                 eax, dword ptr [esp + 0x120]
            //   c3                   | dec                 eax
            //   0f1f4000             | mov                 ebx, dword ptr [esp + 0x128]

        $sequence_2 = { e8???????? 488d056e852500 488b5c2428 488b4c2448 488b7c2450 e8???????? 48c7400801000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d056e852500       | dec                 eax
            //   488b5c2428           | mov                 eax, dword ptr [esp + 0x50]
            //   488b4c2448           | jmp                 0xf35
            //   488b7c2450           | dec                 eax
            //   e8????????           |                     
            //   48c7400801000000     | mov                 edx, edi

        $sequence_3 = { e8???????? 4889d8 e8???????? 4c89e0 0f1f440000 e8???????? 488b9424f8000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889d8               | lea                 eax, [0x2046ab]
            //   e8????????           |                     
            //   4c89e0               | dec                 eax
            //   0f1f440000           | mov                 edx, dword ptr [esp + 0x38]
            //   e8????????           |                     
            //   488b9424f8000000     | dec                 eax

        $sequence_4 = { 4c8b442458 4c8b4c2460 4c8d15f1213300 4989c3 4889c8 4889d1 488bac24a0000000 }
            // n = 7, score = 100
            //   4c8b442458           | dec                 eax
            //   4c8b4c2460           | mov                 ecx, dword ptr [esp + 0x38]
            //   4c8d15f1213300       | dec                 eax
            //   4989c3               | mov                 edx, dword ptr [ecx]
            //   4889c8               | dec                 eax
            //   4889d1               | mov                 ebx, dword ptr [ecx + 0x10]
            //   488bac24a0000000     | dec                 eax

        $sequence_5 = { eb1c 488b4c2460 488b8908010000 488b442468 ffd1 3c03 7505 }
            // n = 7, score = 100
            //   eb1c                 | nop                 dword ptr [eax]
            //   488b4c2460           | dec                 eax
            //   488b8908010000       | mov                 dword ptr [esp + 0x68], eax
            //   488b442468           | dec                 eax
            //   ffd1                 | mov                 ecx, dword ptr [esp + 0x38]
            //   3c03                 | dec                 eax
            //   7505                 | imul                ecx, ecx, 0x3b9aca00

        $sequence_6 = { 8400 833d????????00 750c 488d0da5553c00 488908 eb0f 4889c7 }
            // n = 7, score = 100
            //   8400                 | mov                 eax, ebx
            //   833d????????00       |                     
            //   750c                 | call                ecx
            //   488d0da5553c00       | dec                 eax
            //   488908               | mov                 ecx, dword ptr [eax + 0x20]
            //   eb0f                 | dec                 eax
            //   4889c7               | mov                 eax, ebx

        $sequence_7 = { c3 4889d0 488b5c2468 488b4c2440 488d3dd7323800 be04000000 e8???????? }
            // n = 7, score = 100
            //   c3                   | mov                 ebx, ebx
            //   4889d0               | dec                 ecx
            //   488b5c2468           | mov                 edx, eax
            //   488b4c2440           | dec                 esp
            //   488d3dd7323800       | mov                 dword ptr [esp + 0xd0], ebx
            //   be04000000           | dec                 esp
            //   e8????????           |                     

        $sequence_8 = { bf01000000 4889fe e8???????? 0f1f440000 e8???????? 4889c3 488d05f1d22a00 }
            // n = 7, score = 100
            //   bf01000000           | lea                 eax, [0x1f70db]
            //   4889fe               | dec                 eax
            //   e8????????           |                     
            //   0f1f440000           | mov                 eax, dword ptr [esp + 0x50]
            //   e8????????           |                     
            //   4889c3               | dec                 eax
            //   488d05f1d22a00       | mov                 ebp, dword ptr [esp + 0x398]

        $sequence_9 = { ffd2 488d48ff eb15 31c0 488b6c2468 4883c470 c3 }
            // n = 7, score = 100
            //   ffd2                 | dec                 eax
            //   488d48ff             | test                edx, edx
            //   eb15                 | je                  0x8c0
            //   31c0                 | dec                 esp
            //   488b6c2468           | mov                 dword ptr [esp + 0x48], eax
            //   4883c470             | dec                 eax
            //   c3                   | mov                 dword ptr [esp + 0x28], edx

    condition:
        7 of them and filesize < 19940352
}