rule win_gspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gspy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 8d54241b 52 e8???????? 8944242c 8a442413 8b5c242c }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8d54241b             | lea                 edx, [esp + 0x1b]
            //   52                   | push                edx
            //   e8????????           |                     
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   8a442413             | mov                 al, byte ptr [esp + 0x13]
            //   8b5c242c             | mov                 ebx, dword ptr [esp + 0x2c]

        $sequence_1 = { 83c01c 50 55 56 ff15???????? 85c0 740a }
            // n = 7, score = 100
            //   83c01c               | add                 eax, 0x1c
            //   50                   | push                eax
            //   55                   | push                ebp
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc

        $sequence_2 = { 8a442412 3cff 7567 8b4d04 66c744241c3f2a c744241ec0744200 33c0 }
            // n = 7, score = 100
            //   8a442412             | mov                 al, byte ptr [esp + 0x12]
            //   3cff                 | cmp                 al, 0xff
            //   7567                 | jne                 0x69
            //   8b4d04               | mov                 ecx, dword ptr [ebp + 4]
            //   66c744241c3f2a       | mov                 word ptr [esp + 0x1c], 0x2a3f
            //   c744241ec0744200     | mov                 dword ptr [esp + 0x1e], 0x4274c0
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { c20400 8b0d???????? 56 33c0 57 8b3d???????? 3bcd }
            // n = 7, score = 100
            //   c20400               | ret                 4
            //   8b0d????????         |                     
            //   56                   | push                esi
            //   33c0                 | xor                 eax, eax
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   3bcd                 | cmp                 ecx, ebp

        $sequence_4 = { 85c0 757a 8b442414 8b08 8d542420 52 50 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   757a                 | jne                 0x7c
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8d542420             | lea                 edx, [esp + 0x20]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_5 = { 51 ff15???????? 85ff 7409 8d442418 e8???????? 83c304 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85ff                 | test                edi, edi
            //   7409                 | je                  0xb
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   e8????????           |                     
            //   83c304               | add                 ebx, 4

        $sequence_6 = { 8bf0 89742410 85f6 7449 33c0 897c2414 }
            // n = 6, score = 100
            //   8bf0                 | mov                 esi, eax
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   85f6                 | test                esi, esi
            //   7449                 | je                  0x4b
            //   33c0                 | xor                 eax, eax
            //   897c2414             | mov                 dword ptr [esp + 0x14], edi

        $sequence_7 = { 57 8bf8 32c0 88442407 85ff 0f8456010000 53 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   32c0                 | xor                 al, al
            //   88442407             | mov                 byte ptr [esp + 7], al
            //   85ff                 | test                edi, edi
            //   0f8456010000         | je                  0x15c
            //   53                   | push                ebx

        $sequence_8 = { 8b4124 ffd0 85c0 0f8464ffffff 8b442410 8b08 8b5108 }
            // n = 7, score = 100
            //   8b4124               | mov                 eax, dword ptr [ecx + 0x24]
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   0f8464ffffff         | je                  0xffffff6a
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]

        $sequence_9 = { 7408 3c09 7c0e 3c0d 7f0a 83fa02 }
            // n = 6, score = 100
            //   7408                 | je                  0xa
            //   3c09                 | cmp                 al, 9
            //   7c0e                 | jl                  0x10
            //   3c0d                 | cmp                 al, 0xd
            //   7f0a                 | jg                  0xc
            //   83fa02               | cmp                 edx, 2

    condition:
        7 of them and filesize < 421888
}