rule win_guidloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.guidloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.guidloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 498bd4 e8???????? 837d1000 0f8659020000 44896c2428 488d5510 4c8bcf }
            // n = 7, score = 100
            //   498bd4               | jne                 0x15c2
            //   e8????????           |                     
            //   837d1000             | dec                 eax
            //   0f8659020000         | mov                 ecx, eax
            //   44896c2428           | dec                 eax
            //   488d5510             | lea                 edx, [0x6f95]
            //   4c8bcf               | dec                 eax

        $sequence_1 = { 4d2bc8 418b51fc d3ea 4c894808 895018 410fb609 }
            // n = 6, score = 100
            //   4d2bc8               | jne                 0x20
            //   418b51fc             | dec                 esp
            //   d3ea                 | mov                 ecx, edx
            //   4c894808             | jmp                 0x4f
            //   895018               | sub                 esi, edx
            //   410fb609             | inc                 esp

        $sequence_2 = { 83f802 7711 488b4228 49394128 418b08 0f44cf }
            // n = 6, score = 100
            //   83f802               | mov                 eax, dword ptr [ebp + 0x110]
            //   7711                 | dec                 ebp
            //   488b4228             | mov                 ecx, ebp
            //   49394128             | dec                 eax
            //   418b08               | mov                 dword ptr [esp + 0x38], ebx
            //   0f44cf               | dec                 ebp

        $sequence_3 = { e8???????? 4533c0 4c8d0dcd72ffff 498b5508 0fb60a 83e10f 4a0fbe840920460100 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4533c0               | mov                 eax, 0xffffffff
            //   4c8d0dcd72ffff       | dec                 eax
            //   498b5508             | lea                 ebp, [0xffff5daf]
            //   0fb60a               | dec                 eax
            //   83e10f               | mov                 dword ptr [esp + 0x20], esi
            //   4a0fbe840920460100     | ret    

        $sequence_4 = { 4c8d442448 488d1532700000 33c9 ff15???????? 488b4c2448 85c0 }
            // n = 6, score = 100
            //   4c8d442448           | dec                 ecx
            //   488d1532700000       | shr                 eax, 0x20
            //   33c9                 | inc                 ebp
            //   ff15????????         |                     
            //   488b4c2448           | cmp                 ecx, esi
            //   85c0                 | jne                 0x5ff

        $sequence_5 = { 418807 4c852e 764f ba30000000 49b80000000000000f00 6666660f1f840000000000 488b06 }
            // n = 7, score = 100
            //   418807               | mov                 dword ptr [esp + 0x68], eax
            //   4c852e               | dec                 eax
            //   764f                 | test                eax, eax
            //   ba30000000           | xor                 eax, eax
            //   49b80000000000000f00     | mov    dword ptr [ebp + 0x508], 0x100000
            //   6666660f1f840000000000     | mov    dword ptr [ebp + 0x504], eax
            //   488b06               | mov                 dword ptr [ebp + 0x500], 2

        $sequence_6 = { 4889442460 4863842420010000 4889442468 0fb6842440010000 0f298c2480000000 0f280d???????? }
            // n = 6, score = 100
            //   4889442460           | dec                 eax
            //   4863842420010000     | mov                 edx, eax
            //   4889442468           | dec                 esp
            //   0fb6842440010000     | lea                 ecx, [0xffff6e9b]
            //   0f298c2480000000     | dec                 eax
            //   0f280d????????       |                     

        $sequence_7 = { 898c9564010000 49c1e820 453bcd 75d6 4585c0 742e 8b8560010000 }
            // n = 7, score = 100
            //   898c9564010000       | dec                 eax
            //   49c1e820             | mov                 edx, dword ptr [ebx + 0x460]
            //   453bcd               | inc                 esp
            //   75d6                 | movzx               ecx, word ptr [ecx]
            //   4585c0               | test                al, al
            //   742e                 | je                  0xe43
            //   8b8560010000         | inc                 esp

        $sequence_8 = { 410f1006 0f11442430 e9???????? 488bfe 4883cf0f 483bfb 7629 }
            // n = 7, score = 100
            //   410f1006             | ja                  0x1bd
            //   0f11442430           | mov                 ebx, dword ptr [ebp + 0x164]
            //   e9????????           |                     
            //   488bfe               | dec                 esp
            //   4883cf0f             | mov                 eax, ecx
            //   483bfb               | dec                 ecx
            //   7629                 | shl                 eax, 2

        $sequence_9 = { 894208 f6c310 740a 418b02 4983c204 89420c 807c243000 }
            // n = 7, score = 100
            //   894208               | dec                 ebp
            //   f6c310               | lea                 ecx, [eax + 4]
            //   740a                 | shr                 edx, cl
            //   418b02               | and                 ecx, 0xf
            //   4983c204             | dec                 edx
            //   89420c               | movsx               edx, byte ptr [ecx + ebx + 0x14620]
            //   807c243000           | inc                 edx

    condition:
        7 of them and filesize < 49251328
}