rule win_gup_proxy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gup_proxy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gup_proxy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 660f6f05???????? f30f7f854cfaffff 660f6f05???????? f30f7f855cfaffff 660f6f05???????? }
            // n = 5, score = 100
            //   660f6f05????????     |                     
            //   f30f7f854cfaffff     | movdqu              xmmword ptr [ebp - 0x5b4], xmm0
            //   660f6f05????????     |                     
            //   f30f7f855cfaffff     | movdqu              xmmword ptr [ebp - 0x5a4], xmm0
            //   660f6f05????????     |                     

        $sequence_1 = { 8bc1 8b4df8 5e 33cd 5b e8???????? 8be5 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   5e                   | pop                 esi
            //   33cd                 | xor                 ecx, ebp
            //   5b                   | pop                 ebx
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp

        $sequence_2 = { 8b4dfc f7d2 5f 5e 33cd 8bc2 5b }
            // n = 7, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   f7d2                 | not                 edx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33cd                 | xor                 ecx, ebp
            //   8bc2                 | mov                 eax, edx
            //   5b                   | pop                 ebx

        $sequence_3 = { 8b5d08 8d85e0f5ffff 56 57 8bf1 8995dcf5ffff }
            // n = 6, score = 100
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8d85e0f5ffff         | lea                 eax, [ebp - 0xa20]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   8995dcf5ffff         | mov                 dword ptr [ebp - 0xa24], edx

        $sequence_4 = { eb83 890cb510974100 013d???????? 8b04b510974100 0500080000 3bc8 }
            // n = 6, score = 100
            //   eb83                 | jmp                 0xffffff85
            //   890cb510974100       | mov                 dword ptr [esi*4 + 0x419710], ecx
            //   013d????????         |                     
            //   8b04b510974100       | mov                 eax, dword ptr [esi*4 + 0x419710]
            //   0500080000           | add                 eax, 0x800
            //   3bc8                 | cmp                 ecx, eax

        $sequence_5 = { 8bce e8???????? 6a04 8d8588feffff c78588feffffc22eab48 50 }
            // n = 6, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a04                 | push                4
            //   8d8588feffff         | lea                 eax, [ebp - 0x178]
            //   c78588feffffc22eab48     | mov    dword ptr [ebp - 0x178], 0x48ab2ec2
            //   50                   | push                eax

        $sequence_6 = { c7461000000000 7204 8b06 eb02 8bc6 c60000 837e1410 }
            // n = 7, score = 100
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   7204                 | jb                  6
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   eb02                 | jmp                 4
            //   8bc6                 | mov                 eax, esi
            //   c60000               | mov                 byte ptr [eax], 0
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10

        $sequence_7 = { f30f7f45e8 6a50 8bf9 668945e8 }
            // n = 4, score = 100
            //   f30f7f45e8           | movdqu              xmmword ptr [ebp - 0x18], xmm0
            //   6a50                 | push                0x50
            //   8bf9                 | mov                 edi, ecx
            //   668945e8             | mov                 word ptr [ebp - 0x18], ax

        $sequence_8 = { 88858afeffff 8bc3 c1e808 888589feffff 8d8588feffff }
            // n = 5, score = 100
            //   88858afeffff         | mov                 byte ptr [ebp - 0x176], al
            //   8bc3                 | mov                 eax, ebx
            //   c1e808               | shr                 eax, 8
            //   888589feffff         | mov                 byte ptr [ebp - 0x177], al
            //   8d8588feffff         | lea                 eax, [ebp - 0x178]

        $sequence_9 = { f30f7f853cffffff 660f6f05???????? f30f7f854cffffff 660f6f05???????? }
            // n = 4, score = 100
            //   f30f7f853cffffff     | movdqu              xmmword ptr [ebp - 0xc4], xmm0
            //   660f6f05????????     |                     
            //   f30f7f854cffffff     | movdqu              xmmword ptr [ebp - 0xb4], xmm0
            //   660f6f05????????     |                     

    condition:
        7 of them and filesize < 247808
}