rule win_h1n1_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.h1n1."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.h1n1"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { bb09000000 eb6c 83bde8feffff0a 7563 }
            // n = 4, score = 400
            //   bb09000000           | mov                 ebx, 9
            //   eb6c                 | jmp                 0x6e
            //   83bde8feffff0a       | cmp                 dword ptr [ebp - 0x118], 0xa
            //   7563                 | jne                 0x65

        $sequence_1 = { 51 8b7df4 b900100000 33c0 f3aa 59 }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   b900100000           | mov                 ecx, 0x1000
            //   33c0                 | xor                 eax, eax
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   59                   | pop                 ecx

        $sequence_2 = { c745cc01000000 c745d010000000 c745d402000000 c745d820000000 c745dc04000000 c745e040000000 }
            // n = 6, score = 400
            //   c745cc01000000       | mov                 dword ptr [ebp - 0x34], 1
            //   c745d010000000       | mov                 dword ptr [ebp - 0x30], 0x10
            //   c745d402000000       | mov                 dword ptr [ebp - 0x2c], 2
            //   c745d820000000       | mov                 dword ptr [ebp - 0x28], 0x20
            //   c745dc04000000       | mov                 dword ptr [ebp - 0x24], 4
            //   c745e040000000       | mov                 dword ptr [ebp - 0x20], 0x40

        $sequence_3 = { ff05???????? 6800020000 ff35???????? 58 }
            // n = 4, score = 400
            //   ff05????????         |                     
            //   6800020000           | push                0x200
            //   ff35????????         |                     
            //   58                   | pop                 eax

        $sequence_4 = { 3503003400 ab 2d0e00fcff ab }
            // n = 4, score = 400
            //   3503003400           | xor                 eax, 0x340003
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   2d0e00fcff           | sub                 eax, 0xfffc000e
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_5 = { ffd0 ff750c ff75f0 ff75f4 8d45b8 50 e8???????? }
            // n = 7, score = 400
            //   ffd0                 | call                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { c745e404000000 c745e840000000 0fb77b06 8db3f8000000 33c9 f7462400000020 7403 }
            // n = 7, score = 400
            //   c745e404000000       | mov                 dword ptr [ebp - 0x1c], 4
            //   c745e840000000       | mov                 dword ptr [ebp - 0x18], 0x40
            //   0fb77b06             | movzx               edi, word ptr [ebx + 6]
            //   8db3f8000000         | lea                 esi, [ebx + 0xf8]
            //   33c9                 | xor                 ecx, ecx
            //   f7462400000020       | test                dword ptr [esi + 0x24], 0x20000000
            //   7403                 | je                  5

        $sequence_7 = { ff75f8 ff7508 ff75fc ff75f4 ff35???????? 58 ffd0 }
            // n = 7, score = 400
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff35????????         |                     
            //   58                   | pop                 eax
            //   ffd0                 | call                eax

        $sequence_8 = { 25ff000000 c1e908 330c85908f0010 42 }
            // n = 4, score = 100
            //   25ff000000           | and                 eax, 0xff
            //   c1e908               | shr                 ecx, 8
            //   330c85908f0010       | xor                 ecx, dword ptr [eax*4 + 0x10008f90]
            //   42                   | inc                 edx

        $sequence_9 = { 8bc1 83e001 d1e9 330c8500850010 330c95f48b0010 42 890c95bc850010 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   83e001               | and                 eax, 1
            //   d1e9                 | shr                 ecx, 1
            //   330c8500850010       | xor                 ecx, dword ptr [eax*4 + 0x10008500]
            //   330c95f48b0010       | xor                 ecx, dword ptr [edx*4 + 0x10008bf4]
            //   42                   | inc                 edx
            //   890c95bc850010       | mov                 dword ptr [edx*4 + 0x100085bc], ecx

        $sequence_10 = { 8b442404 33d2 a3???????? 42 b9c0850010 8b01 c1e81e }
            // n = 7, score = 100
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   33d2                 | xor                 edx, edx
            //   a3????????           |                     
            //   42                   | inc                 edx
            //   b9c0850010           | mov                 ecx, 0x100085c0
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   c1e81e               | shr                 eax, 0x1e

        $sequence_11 = { 50 68fc600010 6804010000 ff7508 e8???????? 83c424 c9 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   68fc600010           | push                0x100060fc
            //   6804010000           | push                0x104
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   c9                   | leave               

        $sequence_12 = { 81ff7c8f0010 7cd4 5f 8b0d???????? 330d???????? }
            // n = 5, score = 100
            //   81ff7c8f0010         | cmp                 edi, 0x10008f7c
            //   7cd4                 | jl                  0xffffffd6
            //   5f                   | pop                 edi
            //   8b0d????????         |                     
            //   330d????????         |                     

        $sequence_13 = { d1e9 330c8500850010 330d???????? 890d???????? 8b0cb5c0850010 8bc1 c1e80b }
            // n = 7, score = 100
            //   d1e9                 | shr                 ecx, 1
            //   330c8500850010       | xor                 ecx, dword ptr [eax*4 + 0x10008500]
            //   330d????????         |                     
            //   890d????????         |                     
            //   8b0cb5c0850010       | mov                 ecx, dword ptr [esi*4 + 0x100085c0]
            //   8bc1                 | mov                 eax, ecx
            //   c1e80b               | shr                 eax, 0xb

        $sequence_14 = { 33f6 53 8bd6 bbffffff7f 8b0c95c4850010 330c95c0850010 23cb }
            // n = 7, score = 100
            //   33f6                 | xor                 esi, esi
            //   53                   | push                ebx
            //   8bd6                 | mov                 edx, esi
            //   bbffffff7f           | mov                 ebx, 0x7fffffff
            //   8b0c95c4850010       | mov                 ecx, dword ptr [edx*4 + 0x100085c4]
            //   330c95c0850010       | xor                 ecx, dword ptr [edx*4 + 0x100085c0]
            //   23cb                 | and                 ecx, ebx

        $sequence_15 = { 68f4600010 56 e8???????? 8bf0 59 }
            // n = 5, score = 100
            //   68f4600010           | push                0x100060f4
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 172032
}