rule win_hackbrowserdata_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hackbrowserdata."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hackbrowserdata"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffc1 4d89ea 4d89fc 4989fd 4d89e7 41394c2428 0f8e0dfaffff }
            // n = 7, score = 100
            //   ffc1                 | mov                 dword ptr [esp + 0x28], eax
            //   4d89ea               | dec                 eax
            //   4d89fc               | mov                 dword ptr [eax], 0
            //   4989fd               | dec                 eax
            //   4d89e7               | mov                 dword ptr [esp + 0x18], eax
            //   41394c2428           | mov                 byte ptr [eax], 0xb6
            //   0f8e0dfaffff         | dec                 eax

        $sequence_1 = { f20f1005???????? 31db 49c7c0ffffffff eb3d 48890437 488bb424a0000000 4883c618 }
            // n = 7, score = 100
            //   f20f1005????????     |                     
            //   31db                 | test                dl, dl
            //   49c7c0ffffffff       | je                  0x6d8
            //   eb3d                 | dec                 eax
            //   48890437             | cmp                 eax, 1
            //   488bb424a0000000     | je                  0x6c6
            //   4883c618             | dec                 eax

        $sequence_2 = { e8???????? 488b542450 48895008 833d????????00 750a 488b9424d8000000 eb10 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b542450           | mov                 eax, 0x49
            //   48895008             | call                ecx
            //   833d????????00       |                     
            //   750a                 | dec                 eax
            //   488b9424d8000000     | mov                 ecx, dword ptr [eax]
            //   eb10                 | dec                 eax

        $sequence_3 = { e8???????? e9???????? 488b1d???????? 4881c368960000 488b442478 488b4c2448 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   488b1d????????       |                     
            //   4881c368960000       | dec                 eax
            //   488b442478           | mov                 edi, dword ptr [esp + 0x48]
            //   488b4c2448           | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { ffd3 833d????????00 7507 488b742408 eb15 e8???????? 498903 }
            // n = 7, score = 100
            //   ffd3                 | dec                 eax
            //   833d????????00       |                     
            //   7507                 | mov                 dword ptr [eax], 0
            //   488b742408           | dec                 eax
            //   eb15                 | lea                 eax, [0x9ceffb]
            //   e8????????           |                     
            //   498903               | dec                 eax

        $sequence_5 = { e9???????? 488d4f54 4889ca 0fb619 ffcb 8819 480fbe0a }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d4f54             | mov                 dword ptr [esp + 0x50], ebx
            //   4889ca               | inc                 esp
            //   0fb619               | movups              xmmword ptr [esp + 0xb0], xmm7
            //   ffcb                 | dec                 eax
            //   8819                 | mov                 eax, dword ptr [esp + 0x48]
            //   480fbe0a             | ret                 

        $sequence_6 = { f20f59d8 f20f581d???????? f20f59d8 f20f581d???????? f20f59d8 f20f581d???????? f20f59d9 }
            // n = 7, score = 100
            //   f20f59d8             | jne                 0xa07
            //   f20f581d????????     |                     
            //   f20f59d8             | dec                 eax
            //   f20f581d????????     |                     
            //   f20f59d8             | lea                 eax, [0x9d80af]
            //   f20f581d????????     |                     
            //   f20f59d9             | dec                 eax

        $sequence_7 = { ffc1 39d1 7d5d 4889f7 488b7640 4c63c1 4a8d34c6 }
            // n = 7, score = 100
            //   ffc1                 | mov                 byte ptr [eax], 0x90
            //   39d1                 | dec                 eax
            //   7d5d                 | lea                 eax, [0x91f3b3]
            //   4889f7               | dec                 eax
            //   488b7640             | mov                 dword ptr [esp + 0x28], eax
            //   4c63c1               | dec                 eax
            //   4a8d34c6             | mov                 dword ptr [eax], 0

        $sequence_8 = { eb13 4883c420 5d c3 48bfffffffffffff0300 4989da 4585c0 }
            // n = 7, score = 100
            //   eb13                 | dec                 eax
            //   4883c420             | mov                 ebx, dword ptr [esp + 0x180]
            //   5d                   | dec                 eax
            //   c3                   | mov                 edx, ebx
            //   48bfffffffffffff0300     | movzx    edx, byte ptr [edx]
            //   4989da               | dec                 eax
            //   4585c0               | lea                 esi, [0xe8d4dc]

        $sequence_9 = { e8???????? 498913 48895018 488b942480000000 488b5c2470 4889f9 4c89c7 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   498913               | nop                 
            //   48895018             | dec                 eax
            //   488b942480000000     | lea                 eax, [0x56539c]
            //   488b5c2470           | mov                 ebx, 1
            //   4889f9               | dec                 eax
            //   4c89c7               | mov                 dword ptr [esp + 0x260], eax

    condition:
        7 of them and filesize < 42451968
}