rule win_halfrig_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.halfrig."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.halfrig"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8ea3000000 488d0daf800800 e8???????? 833d????????ff 0f858a000000 488d542420 488d8530030000 }
            // n = 7, score = 100
            //   0f8ea3000000         | inc                 eax
            //   488d0daf800800       | mov                 byte ptr [ebx + 0x588], dh
            //   e8????????           |                     
            //   833d????????ff       |                     
            //   0f858a000000         | jle                 0x10a4
            //   488d542420           | dec                 eax
            //   488d8530030000       | lea                 ecx, [0x46670]

        $sequence_1 = { 488d542420 e8???????? 488d0db8bd0700 e8???????? 40383d???????? }
            // n = 5, score = 100
            //   488d542420           | movups              xmmword ptr [ecx - 0x10], xmm1
            //   e8????????           |                     
            //   488d0db8bd0700       | dec                 eax
            //   e8????????           |                     
            //   40383d????????       |                     

        $sequence_2 = { 4c893d???????? 488d8d30030000 488d05acd70200 488bd6 660f1f840000000000 488d8980000000 0f1000 }
            // n = 7, score = 100
            //   4c893d????????       |                     
            //   488d8d30030000       | je                  0x1045
            //   488d05acd70200       | dec                 eax
            //   488bd6               | mov                 edx, edi
            //   660f1f840000000000     | dec    esp
            //   488d8980000000       | mov                 eax, esi
            //   0f1000               | nop                 dword ptr [eax]

        $sequence_3 = { 3905???????? 0f8ea3000000 488d0ddf8d0700 e8???????? 833d????????ff 0f858a000000 488d542420 }
            // n = 7, score = 100
            //   3905????????         |                     
            //   0f8ea3000000         | jne                 0x19b8
            //   488d0ddf8d0700       | movzx               eax, byte ptr [eax]
            //   e8????????           |                     
            //   833d????????ff       |                     
            //   0f858a000000         | dec                 esp
            //   488d542420           | lea                 edi, [0x76473]

        $sequence_4 = { 0f8ea3000000 488d0d2f6c0700 e8???????? 833d????????ff 0f858a000000 488d542420 4c8bc6 }
            // n = 7, score = 100
            //   0f8ea3000000         | jle                 0xafc
            //   488d0d2f6c0700       | dec                 eax
            //   e8????????           |                     
            //   833d????????ff       |                     
            //   0f858a000000         | lea                 ecx, [0x6bfcf]
            //   488d542420           | inc                 ecx
            //   4c8bc6               | mov                 eax, dword ptr [esi]

        $sequence_5 = { 4983f815 72db 408835???????? 418b06 4c898b50040000 4088b358040000 3905???????? }
            // n = 7, score = 100
            //   4983f815             | lea                 ecx, [ecx + 0x80]
            //   72db                 | dec                 eax
            //   408835????????       |                     
            //   418b06               | lea                 ecx, [ebp + 0x330]
            //   4c898b50040000       | dec                 eax
            //   4088b358040000       | lea                 eax, [0x1cd4c]
            //   3905????????         |                     

        $sequence_6 = { 0f1003 488d542420 488bcd 0f29442420 e8???????? 0fb6d0 488d5b10 }
            // n = 7, score = 100
            //   0f1003               | dec                 eax
            //   488d542420           | mov                 eax, dword ptr [0x58]
            //   488bcd               | mov                 edx, 4
            //   0f29442420           | movzx               eax, byte ptr [eax]
            //   e8????????           |                     
            //   0fb6d0               | dec                 esp
            //   488d5b10             | lea                 edi, [0x836f3]

        $sequence_7 = { 8801 418b06 3905???????? 0f8ea3000000 488d0dcf4f0700 e8???????? 833d????????ff }
            // n = 7, score = 100
            //   8801                 | inc                 ecx
            //   418b06               | mov                 eax, dword ptr [esi]
            //   3905????????         |                     
            //   0f8ea3000000         | jle                 0x11cd
            //   488d0dcf4f0700       | dec                 eax
            //   e8????????           |                     
            //   833d????????ff       |                     

        $sequence_8 = { 418b06 4c898ba0040000 4088b3a8040000 3905???????? 7e4e 488d0d34700400 e8???????? }
            // n = 7, score = 100
            //   418b06               | nop                 word ptr [eax + eax]
            //   4c898ba0040000       | dec                 eax
            //   4088b3a8040000       | lea                 ecx, [ecx + 0x80]
            //   3905????????         |                     
            //   7e4e                 | movups              xmm0, xmmword ptr [eax]
            //   488d0d34700400       | movups              xmm1, xmmword ptr [eax + 0x10]
            //   e8????????           |                     

        $sequence_9 = { c705????????6990e984 c705????????3d6d27f5 e8???????? 403835???????? 4c8d0d0e7b0400 7438 }
            // n = 6, score = 100
            //   c705????????6990e984     |     
            //   c705????????3d6d27f5     |     
            //   e8????????           |                     
            //   403835????????       |                     
            //   4c8d0d0e7b0400       | dec                 eax
            //   7438                 | lea                 edx, [esp + 0x20]

    condition:
        7 of them and filesize < 1369088
}