rule win_havoc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.havoc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.havoc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7512 31c0 80bc245e01000001 0f94c0 }
            // n = 4, score = 800
            //   7512                 | mov                 edx, dword ptr [esp + 0x24]
            //   31c0                 | dec                 eax
            //   80bc245e01000001     | mov                 edx, dword ptr [edx + 0x20]
            //   0f94c0               | dec                 ecx

        $sequence_1 = { 4489c0 4501c0 c0e807 4531cf 448a4afe }
            // n = 5, score = 800
            //   4489c0               | mov                 eax, 0xffff
            //   4501c0               | xor                 edx, edx
            //   c0e807               | je                  0x130e
            //   4531cf               | dec                 eax
            //   448a4afe             | mov                 edi, dword ptr [eax + 0x2dc]

        $sequence_2 = { 884c2439 8a4c243a 8844243a 8a442436 884c2432 8a4c243e 8844243e }
            // n = 7, score = 800
            //   884c2439             | dec                 eax
            //   8a4c243a             | mov                 edx, esi
            //   8844243a             | mov                 dword ptr [esp + 0x30], 0x20
            //   8a442436             | call                dword ptr [eax + 0x274]
            //   884c2432             | dec                 esp
            //   8a4c243e             | mov                 eax, dword ptr [eax + 0x294]
            //   8844243e             | mov                 dword ptr [esp + 0x30], 0x20

        $sequence_3 = { 4154 55 89cd b940000000 }
            // n = 4, score = 800
            //   4154                 | dec                 ecx
            //   55                   | mov                 esp, eax
            //   89cd                 | dec                 eax
            //   b940000000           | lea                 eax, [eax + esi]

        $sequence_4 = { 83f902 7512 31c0 80bc245e01000001 0f94c0 }
            // n = 5, score = 800
            //   83f902               | dec                 eax
            //   7512                 | sub                 esp, 0x500
            //   31c0                 | dec                 eax
            //   80bc245e01000001     | mov                 ecx, ebx
            //   0f94c0               | dec                 eax

        $sequence_5 = { 488b01 ff5018 85c0 75e2 488b0b }
            // n = 5, score = 800
            //   488b01               | mov                 dword ptr [esp + 0x20], 0
            //   ff5018               | call                dword ptr [eax + 0x564]
            //   85c0                 | test                eax, eax
            //   75e2                 | js                  0x1646
            //   488b0b               | mov                 dword ptr [esp + 0x20], 0

        $sequence_6 = { 4889cb 4883ec78 4885c9 7507 31c0 e9???????? 4889d1 }
            // n = 7, score = 800
            //   4889cb               | dec                 esp
            //   4883ec78             | mov                 dword ptr [eax + esi*8], eax
            //   4885c9               | mov                 dword ptr [edi + 0x5c], eax
            //   7507                 | dec                 eax
            //   31c0                 | mov                 eax, dword ptr [ebx]
            //   e9????????           |                     
            //   4889d1               | dec                 eax

        $sequence_7 = { 4883ec20 e8???????? 488b06 488b5608 488983f0000000 488993f8000000 488d65f0 }
            // n = 7, score = 800
            //   4883ec20             | mov                 dword ptr [esp + 0x40], edx
            //   e8????????           |                     
            //   488b06               | dec                 eax
            //   488b5608             | mov                 eax, dword ptr [esi]
            //   488983f0000000       | movzx               edx, word ptr [edx + 2]
            //   488993f8000000       | dec                 eax
            //   488d65f0             | shl                 edx, 4

        $sequence_8 = { 4989d0 31d2 4c898c2488000000 498b0424 4c8d8c2480000000 4c894c2438 4c894c2428 }
            // n = 7, score = 800
            //   4989d0               | je                  0xf6d
            //   31d2                 | call                dword ptr [eax + 0x11c]
            //   4c898c2488000000     | dec                 eax
            //   498b0424             | mov                 eax, dword ptr [ebx]
            //   4c8d8c2480000000     | dec                 eax
            //   4c894c2438           | mov                 edx, dword ptr [eax + 0x6b0]
            //   4c894c2428           | dec                 eax

        $sequence_9 = { 7407 488b442428 eb1b 488b06 4883c9ff }
            // n = 5, score = 800
            //   7407                 | mov                 ecx, dword ptr [esp + 0x68]
            //   488b442428           | dec                 esp
            //   eb1b                 | mov                 eax, dword ptr [eax + 0x5dc]
            //   488b06               | inc                 esp
            //   4883c9ff             | mov                 dword ptr [esp + 0x28], ecx

    condition:
        7 of them and filesize < 164864
}