rule win_headertip_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.headertip."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.headertip"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c645e465 c645e573 c645e674 c645e757 885de8 }
            // n = 5, score = 100
            //   c645e465             | mov                 byte ptr [ebp - 0x1c], 0x65
            //   c645e573             | mov                 byte ptr [ebp - 0x1b], 0x73
            //   c645e674             | mov                 byte ptr [ebp - 0x1a], 0x74
            //   c645e757             | mov                 byte ptr [ebp - 0x19], 0x57
            //   885de8               | mov                 byte ptr [ebp - 0x18], bl

        $sequence_1 = { 8b450c 48 753a 8b4508 }
            // n = 4, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   48                   | dec                 eax
            //   753a                 | jne                 0x3c
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_2 = { 0f845b020000 8d4d34 51 50 ff15???????? a3???????? }
            // n = 6, score = 100
            //   0f845b020000         | je                  0x261
            //   8d4d34               | lea                 ecx, [ebp + 0x34]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_3 = { 84c9 75f1 c20400 8b542404 33c0 85d2 }
            // n = 6, score = 100
            //   84c9                 | test                cl, cl
            //   75f1                 | jne                 0xfffffff3
            //   c20400               | ret                 4
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   33c0                 | xor                 eax, eax
            //   85d2                 | test                edx, edx

        $sequence_4 = { 56 57 64a130000000 8b400c 8b7014 8bfe }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   64a130000000         | mov                 eax, dword ptr fs:[0x30]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b7014               | mov                 esi, dword ptr [eax + 0x14]
            //   8bfe                 | mov                 edi, esi

        $sequence_5 = { c6451d74 c6451e45 c6451f72 c6452072 c645216f c6452272 885d23 }
            // n = 7, score = 100
            //   c6451d74             | mov                 byte ptr [ebp + 0x1d], 0x74
            //   c6451e45             | mov                 byte ptr [ebp + 0x1e], 0x45
            //   c6451f72             | mov                 byte ptr [ebp + 0x1f], 0x72
            //   c6452072             | mov                 byte ptr [ebp + 0x20], 0x72
            //   c645216f             | mov                 byte ptr [ebp + 0x21], 0x6f
            //   c6452272             | mov                 byte ptr [ebp + 0x22], 0x72
            //   885d23               | mov                 byte ptr [ebp + 0x23], bl

        $sequence_6 = { ff7508 ff35???????? ff15???????? 85c0 7528 }
            // n = 5, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7528                 | jne                 0x2a

        $sequence_7 = { 68???????? be???????? 56 c705????????19100010 c705????????5b120010 ff15???????? }
            // n = 6, score = 100
            //   68????????           |                     
            //   be????????           |                     
            //   56                   | push                esi
            //   c705????????19100010     |     
            //   c705????????5b120010     |     
            //   ff15????????         |                     

        $sequence_8 = { 58 668945f4 668945f6 6a33 58 668945f8 6a32 }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   668945f4             | mov                 word ptr [ebp - 0xc], ax
            //   668945f6             | mov                 word ptr [ebp - 0xa], ax
            //   6a33                 | push                0x33
            //   58                   | pop                 eax
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   6a32                 | push                0x32

        $sequence_9 = { 33c0 5f 5b 5e c3 0fb7c7 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   0fb7c7               | movzx               eax, di

    condition:
        7 of them and filesize < 174080
}