rule win_heloag_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.heloag."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.heloag"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 f3a5 8a0d???????? 8dbdadfdffff 888dacfdffff }
            // n = 5, score = 300
            //   33c0                 | xor                 eax, eax
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8a0d????????         |                     
            //   8dbdadfdffff         | lea                 edi, [ebp - 0x253]
            //   888dacfdffff         | mov                 byte ptr [ebp - 0x254], cl

        $sequence_1 = { a1???????? 6889130000 68???????? 8b4810 51 e8???????? 83f8ff }
            // n = 7, score = 300
            //   a1????????           |                     
            //   6889130000           | push                0x1389
            //   68????????           |                     
            //   8b4810               | mov                 ecx, dword ptr [eax + 0x10]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1

        $sequence_2 = { 3bc2 7e7f 33f6 ff15???????? 257f000080 7905 }
            // n = 6, score = 300
            //   3bc2                 | cmp                 eax, edx
            //   7e7f                 | jle                 0x81
            //   33f6                 | xor                 esi, esi
            //   ff15????????         |                     
            //   257f000080           | and                 eax, 0x8000007f
            //   7905                 | jns                 7

        $sequence_3 = { 90 90 8b45e4 b919000000 25ffff0000 99 }
            // n = 6, score = 300
            //   90                   | nop                 
            //   90                   | nop                 
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   b919000000           | mov                 ecx, 0x19
            //   25ffff0000           | and                 eax, 0xffff
            //   99                   | cdq                 

        $sequence_4 = { 83c261 52 99 f7f9 8d85dcfdffff 83c261 52 }
            // n = 7, score = 300
            //   83c261               | add                 edx, 0x61
            //   52                   | push                edx
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx
            //   8d85dcfdffff         | lea                 eax, [ebp - 0x224]
            //   83c261               | add                 edx, 0x61
            //   52                   | push                edx

        $sequence_5 = { 50 68???????? ff15???????? 50 ffd3 8d8dd8fcffff }
            // n = 6, score = 300
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8d8dd8fcffff         | lea                 ecx, [ebp - 0x328]

        $sequence_6 = { 99 f7f9 8b45c8 25ffff0000 }
            // n = 4, score = 300
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   25ffff0000           | and                 eax, 0xffff

        $sequence_7 = { 8b0d???????? 8b15???????? 8985e0faffff 66a1???????? }
            // n = 4, score = 300
            //   8b0d????????         |                     
            //   8b15????????         |                     
            //   8985e0faffff         | mov                 dword ptr [ebp - 0x520], eax
            //   66a1????????         |                     

        $sequence_8 = { 8b4e0c 3bcd 8b07 89442410 7464 }
            // n = 5, score = 200
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]
            //   3bcd                 | cmp                 ecx, ebp
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   7464                 | je                  0x66

        $sequence_9 = { 50 53 8bcd ff15???????? 6a00 6a00 8bcd }
            // n = 7, score = 200
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8bcd                 | mov                 ecx, ebp
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8bcd                 | mov                 ecx, ebp

        $sequence_10 = { 7505 a1???????? 894304 8b5608 895308 }
            // n = 5, score = 200
            //   7505                 | jne                 7
            //   a1????????           |                     
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   895308               | mov                 dword ptr [ebx + 8], edx

        $sequence_11 = { f2ae f7d1 49 51 56 68???????? }
            // n = 6, score = 200
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   51                   | push                ecx
            //   56                   | push                esi
            //   68????????           |                     

        $sequence_12 = { 8b11 8bcf 52 6a00 50 }
            // n = 5, score = 200
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8bcf                 | mov                 ecx, edi
            //   52                   | push                edx
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_13 = { ff15???????? 8a4c2413 6a00 884c244c 8d4c244c }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8a4c2413             | mov                 cl, byte ptr [esp + 0x13]
            //   6a00                 | push                0
            //   884c244c             | mov                 byte ptr [esp + 0x4c], cl
            //   8d4c244c             | lea                 ecx, [esp + 0x4c]

        $sequence_14 = { 53 68???????? 8d4c2420 ff15???????? }
            // n = 4, score = 200
            //   53                   | push                ebx
            //   68????????           |                     
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   ff15????????         |                     

        $sequence_15 = { ff15???????? 84c0 7420 8b7d04 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   84c0                 | test                al, al
            //   7420                 | je                  0x22
            //   8b7d04               | mov                 edi, dword ptr [ebp + 4]

    condition:
        7 of them and filesize < 401408
}