rule win_heriplor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.heriplor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.heriplor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 84c9 740d 80c960 01cb }
            // n = 4, score = 300
            //   84c9                 | test                cl, cl
            //   740d                 | je                  0xf
            //   80c960               | or                  cl, 0x60
            //   01cb                 | add                 ebx, ecx

        $sequence_1 = { 56 57 33c9 648b4130 8b400c }
            // n = 5, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c9                 | xor                 ecx, ecx
            //   648b4130             | mov                 eax, dword ptr fs:[ecx + 0x30]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]

        $sequence_2 = { 7420 46 46 46 46 }
            // n = 5, score = 300
            //   7420                 | je                  0x22
            //   46                   | inc                 esi
            //   46                   | inc                 esi
            //   46                   | inc                 esi
            //   46                   | inc                 esi

        $sequence_3 = { 8a08 84c9 740d 80c960 }
            // n = 4, score = 300
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   84c9                 | test                cl, cl
            //   740d                 | je                  0xf
            //   80c960               | or                  cl, 0x60

        $sequence_4 = { 8b0491 01f8 5f 5e 89ec 5d c20800 }
            // n = 7, score = 300
            //   8b0491               | mov                 eax, dword ptr [ecx + edx*4]
            //   01f8                 | add                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   89ec                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8

        $sequence_5 = { 43 ebe6 33d2 668b13 }
            // n = 4, score = 300
            //   43                   | inc                 ebx
            //   ebe6                 | jmp                 0xffffffe8
            //   33d2                 | xor                 edx, edx
            //   668b13               | mov                 dx, word ptr [ebx]

        $sequence_6 = { 3b5d0c 7401 40 5b 59 89ec 5d }
            // n = 7, score = 300
            //   3b5d0c               | cmp                 ebx, dword ptr [ebp + 0xc]
            //   7401                 | je                  3
            //   40                   | inc                 eax
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx
            //   89ec                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_7 = { 5d c20c00 55 89e5 56 57 33c9 }
            // n = 7, score = 300
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c9                 | xor                 ecx, ecx

        $sequence_8 = { 01fb 8b32 01fe 6a01 ff750c 56 e8???????? }
            // n = 7, score = 300
            //   01fb                 | add                 ebx, edi
            //   8b32                 | mov                 esi, dword ptr [edx]
            //   01fe                 | add                 esi, edi
            //   6a01                 | push                1
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_9 = { 43 ebe6 33d2 668b13 8b0491 01f8 }
            // n = 6, score = 300
            //   43                   | inc                 ebx
            //   ebe6                 | jmp                 0xffffffe8
            //   33d2                 | xor                 edx, edx
            //   668b13               | mov                 dx, word ptr [ebx]
            //   8b0491               | mov                 eax, dword ptr [ecx + edx*4]
            //   01f8                 | add                 eax, edi

    condition:
        7 of them and filesize < 49152
}