rule win_hermeticwiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hermeticwiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hermeticwiper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83d1ff 894dbc 03ff 83cf01 ebe7 8b75d4 }
            // n = 6, score = 200
            //   83d1ff               | adc                 ecx, -1
            //   894dbc               | mov                 dword ptr [ebp - 0x44], ecx
            //   03ff                 | add                 edi, edi
            //   83cf01               | or                  edi, 1
            //   ebe7                 | jmp                 0xffffffe9
            //   8b75d4               | mov                 esi, dword ptr [ebp - 0x2c]

        $sequence_1 = { 68???????? eb2f ff15???????? 3d7e040000 0f8522040000 837df800 }
            // n = 6, score = 200
            //   68????????           |                     
            //   eb2f                 | jmp                 0x31
            //   ff15????????         |                     
            //   3d7e040000           | cmp                 eax, 0x47e
            //   0f8522040000         | jne                 0x428
            //   837df800             | cmp                 dword ptr [ebp - 8], 0

        $sequence_2 = { 0f86fe000000 8b55d0 8d4630 8945f8 6690 8b00 85c0 }
            // n = 7, score = 200
            //   0f86fe000000         | jbe                 0x104
            //   8b55d0               | mov                 edx, dword ptr [ebp - 0x30]
            //   8d4630               | lea                 eax, [esi + 0x30]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   6690                 | nop                 
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   85c0                 | test                eax, eax

        $sequence_3 = { 53 51 51 52 b980000000 e8???????? 8b4c2428 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   52                   | push                edx
            //   b980000000           | mov                 ecx, 0x80
            //   e8????????           |                     
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_4 = { 8845fb 84e4 0f856dfeffff 5f 5e 5b 8be5 }
            // n = 7, score = 200
            //   8845fb               | mov                 byte ptr [ebp - 5], al
            //   84e4                 | test                ah, ah
            //   0f856dfeffff         | jne                 0xfffffe73
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_5 = { 8b4e10 8b7e08 03cf 8b560c 8b4614 13c2 89542418 }
            // n = 7, score = 200
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   8b7e08               | mov                 edi, dword ptr [esi + 8]
            //   03cf                 | add                 ecx, edi
            //   8b560c               | mov                 edx, dword ptr [esi + 0xc]
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   13c2                 | adc                 eax, edx
            //   89542418             | mov                 dword ptr [esp + 0x18], edx

        $sequence_6 = { 83ee02 eb02 8bf3 397df0 7531 6a5c 6a00 }
            // n = 7, score = 200
            //   83ee02               | sub                 esi, 2
            //   eb02                 | jmp                 4
            //   8bf3                 | mov                 esi, ebx
            //   397df0               | cmp                 dword ptr [ebp - 0x10], edi
            //   7531                 | jne                 0x33
            //   6a5c                 | push                0x5c
            //   6a00                 | push                0

        $sequence_7 = { 8b401c 83c118 03c1 8b4c2414 89442424 3bf0 736e }
            // n = 7, score = 200
            //   8b401c               | mov                 eax, dword ptr [eax + 0x1c]
            //   83c118               | add                 ecx, 0x18
            //   03c1                 | add                 eax, ecx
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   3bf0                 | cmp                 esi, eax
            //   736e                 | jae                 0x70

        $sequence_8 = { 57 56 ff15???????? 85c0 752a ff15???????? 33ff }
            // n = 7, score = 200
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   752a                 | jne                 0x2c
            //   ff15????????         |                     
            //   33ff                 | xor                 edi, edi

        $sequence_9 = { 5e b801000000 5b 8be5 5d c20c00 8b7510 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 247808
}