rule win_highnote_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.highnote."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.highnote"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3c7b bc9e36398f 8027e9 82ad42476080cd e009 }
            // n = 5, score = 200
            //   3c7b                 | cmp                 al, 0x7b
            //   bc9e36398f           | mov                 esp, 0x8f39369e
            //   8027e9               | and                 byte ptr [edi], 0xe9
            //   82ad42476080cd       | sub                 byte ptr [ebp - 0x7f9fb8be], 0xcd
            //   e009                 | loopne              0xb

        $sequence_1 = { 47 365e 3007 7bae 97 9d 884d13 }
            // n = 7, score = 200
            //   47                   | inc                 edi
            //   365e                 | pop                 esi
            //   3007                 | xor                 byte ptr [edi], al
            //   7bae                 | jnp                 0xffffffb0
            //   97                   | xchg                eax, edi
            //   9d                   | popfd               
            //   884d13               | mov                 byte ptr [ebp + 0x13], cl

        $sequence_2 = { a8b9 a1???????? 9c 6857414608 d4dc 59 93 }
            // n = 7, score = 200
            //   a8b9                 | test                al, 0xb9
            //   a1????????           |                     
            //   9c                   | pushfd              
            //   6857414608           | push                0x8464157
            //   d4dc                 | aam                 0xdc
            //   59                   | pop                 ecx
            //   93                   | xchg                eax, ebx

        $sequence_3 = { 33c5 8945fc 8b4508 53 6808090000 8945e4 e8???????? }
            // n = 7, score = 200
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   6808090000           | push                0x908
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   e8????????           |                     

        $sequence_4 = { 4f 59 7def 889de81be9ec b96b0b724f 262415 3a1f }
            // n = 7, score = 200
            //   4f                   | dec                 edi
            //   59                   | pop                 ecx
            //   7def                 | jge                 0xfffffff1
            //   889de81be9ec         | mov                 byte ptr [ebp - 0x1316e418], bl
            //   b96b0b724f           | mov                 ecx, 0x4f720b6b
            //   262415               | and                 al, 0x15
            //   3a1f                 | cmp                 bl, byte ptr [edi]

        $sequence_5 = { 0e ed 47 6908b79d84b8 6935????????3e1f20f8 4a d14529 }
            // n = 7, score = 200
            //   0e                   | push                cs
            //   ed                   | in                  eax, dx
            //   47                   | inc                 edi
            //   6908b79d84b8         | imul                ecx, dword ptr [eax], 0xb8849db7
            //   6935????????3e1f20f8     |     
            //   4a                   | dec                 edx
            //   d14529               | rol                 dword ptr [ebp + 0x29], 1

        $sequence_6 = { e76e a9a4fec7f3 1b90bff8ccdd b1e4 f7f4 }
            // n = 5, score = 200
            //   e76e                 | out                 0x6e, eax
            //   a9a4fec7f3           | test                eax, 0xf3c7fea4
            //   1b90bff8ccdd         | sbb                 edx, dword ptr [eax - 0x22330741]
            //   b1e4                 | mov                 cl, 0xe4
            //   f7f4                 | div                 esp

        $sequence_7 = { 0f85dc000000 b763 42 20ce e04b 2bea }
            // n = 6, score = 200
            //   0f85dc000000         | jne                 0xe2
            //   b763                 | mov                 bh, 0x63
            //   42                   | inc                 edx
            //   20ce                 | and                 dh, cl
            //   e04b                 | loopne              0x4d
            //   2bea                 | sub                 ebp, edx

        $sequence_8 = { 1cfe 5f 3d4b9c06b4 12a4c5ea7849d5 ba7ab47152 1c98 d24cdca8 }
            // n = 7, score = 200
            //   1cfe                 | sbb                 al, 0xfe
            //   5f                   | pop                 edi
            //   3d4b9c06b4           | cmp                 eax, 0xb4069c4b
            //   12a4c5ea7849d5       | adc                 ah, byte ptr [ebp + eax*8 - 0x2ab68716]
            //   ba7ab47152           | mov                 edx, 0x5271b47a
            //   1c98                 | sbb                 al, 0x98
            //   d24cdca8             | ror                 byte ptr [esp + ebx*8 - 0x58], cl

        $sequence_9 = { 3cff 145d 853e 235ee7 }
            // n = 4, score = 200
            //   3cff                 | cmp                 al, 0xff
            //   145d                 | adc                 al, 0x5d
            //   853e                 | test                dword ptr [esi], edi
            //   235ee7               | and                 ebx, dword ptr [esi - 0x19]

    condition:
        7 of them and filesize < 321536
}