rule win_hikit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hikit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hikit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b442408 39442418 0f84e8000000 c744240401000000 8b442408 89442428 8b442428 }
            // n = 7, score = 100
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   39442418             | cmp                 dword ptr [esp + 0x18], eax
            //   0f84e8000000         | je                  0xee
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]

        $sequence_1 = { 48 c784245001000000000000 48 c744244000000000 48 c784244801000000000000 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   c784245001000000000000     | mov    dword ptr [esp + 0x150], 0
            //   48                   | dec                 eax
            //   c744244000000000     | mov                 dword ptr [esp + 0x40], 0
            //   48                   | dec                 eax
            //   c784244801000000000000     | mov    dword ptr [esp + 0x148], 0
            //   48                   | dec                 eax

        $sequence_2 = { 68???????? 6a24 8b45f8 83c004 50 e8???????? 83c424 }
            // n = 7, score = 100
            //   68????????           |                     
            //   6a24                 | push                0x24
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83c004               | add                 eax, 4
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24

        $sequence_3 = { 52 8d8c2498120000 51 33c9 03c0 8d510c }
            // n = 6, score = 100
            //   52                   | push                edx
            //   8d8c2498120000       | lea                 ecx, [esp + 0x1298]
            //   51                   | push                ecx
            //   33c9                 | xor                 ecx, ecx
            //   03c0                 | add                 eax, eax
            //   8d510c               | lea                 edx, [ecx + 0xc]

        $sequence_4 = { 7408 81f90c000140 7506 8988e0000000 ff7514 ff7510 51 }
            // n = 7, score = 100
            //   7408                 | je                  0xa
            //   81f90c000140         | cmp                 ecx, 0x4001000c
            //   7506                 | jne                 8
            //   8988e0000000         | mov                 dword ptr [eax + 0xe0], ecx
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   51                   | push                ecx

        $sequence_5 = { 0f8427020000 8d8758080000 50 ff15???????? f6460d04 7546 8b4608 }
            // n = 7, score = 100
            //   0f8427020000         | je                  0x22d
            //   8d8758080000         | lea                 eax, [edi + 0x858]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   f6460d04             | test                byte ptr [esi + 0xd], 4
            //   7546                 | jne                 0x48
            //   8b4608               | mov                 eax, dword ptr [esi + 8]

        $sequence_6 = { 48 03c1 48 89442440 48 8b842488010000 0fb600 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   03c1                 | add                 eax, ecx
            //   48                   | dec                 eax
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   48                   | dec                 eax
            //   8b842488010000       | mov                 eax, dword ptr [esp + 0x188]
            //   0fb600               | movzx               eax, byte ptr [eax]

        $sequence_7 = { 85c0 0f8e84000000 48 8b442428 0fb7501a 48 8b4c2428 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f8e84000000         | jle                 0x8a
            //   48                   | dec                 eax
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   0fb7501a             | movzx               edx, word ptr [eax + 0x1a]
            //   48                   | dec                 eax
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_8 = { 7e0c 48 8b442450 c6803201000000 48 8b442450 0fb68031010000 }
            // n = 7, score = 100
            //   7e0c                 | jle                 0xe
            //   48                   | dec                 eax
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]
            //   c6803201000000       | mov                 byte ptr [eax + 0x132], 0
            //   48                   | dec                 eax
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]
            //   0fb68031010000       | movzx               eax, byte ptr [eax + 0x131]

        $sequence_9 = { 48 8b442420 8b5028 48 c1ea0c 48 8b442420 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   8b5028               | mov                 edx, dword ptr [eax + 0x28]
            //   48                   | dec                 eax
            //   c1ea0c               | shr                 edx, 0xc
            //   48                   | dec                 eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]

    condition:
        7 of them and filesize < 573440
}